/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public interface SimpleContainerImpl
extends Container {
    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.getContainerSize() ? this.getContainerItem(slot) : ItemStack.EMPTY;
    }

    @ApiStatus.OverrideOnly
    public ItemStack getContainerItem(int var1);

    default public ItemStack removeItem(int slot, int amount) {
        if (slot >= 0 && slot < this.getContainerSize() && !this.getContainerItem(slot).isEmpty() && amount > 0) {
            ItemStack itemStack = this.removeContainerItem(slot, amount);
            if (!itemStack.isEmpty()) {
                this.setChanged();
            }
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    @ApiStatus.OverrideOnly
    public ItemStack removeContainerItem(int var1, int var2);

    default public ItemStack removeItemNoUpdate(int slot) {
        return slot >= 0 && slot < this.getContainerSize() ? this.removeContainerItemNoUpdate(slot) : ItemStack.EMPTY;
    }

    @ApiStatus.OverrideOnly
    public ItemStack removeContainerItemNoUpdate(int var1);

    default public void setItem(int slot, ItemStack itemStack) {
        if (slot >= 0 && slot < this.getContainerSize()) {
            this.setContainerItem(slot, itemStack);
            if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
                itemStack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }
    }

    @ApiStatus.OverrideOnly
    public void setContainerItem(int var1, ItemStack var2);

    default public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setContainerItem(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }
}

