/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.util.v1;

import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;

public final class InteractionResultHelper {
    public static final InteractionResult SUCCESS = InteractionResult.SUCCESS;
    public static final InteractionResult CONSUME = InteractionResult.CONSUME;
    public static final InteractionResult PASS = InteractionResult.PASS;
    public static final InteractionResult FAIL = InteractionResult.FAIL;
    public static final InteractionResult PASS_TO_DEFAULT_BLOCK_INTERACTION = InteractionResult.TRY_WITH_EMPTY_HAND;
    public static final InteractionResult SKIP_DEFAULT_BLOCK_INTERACTION = InteractionResult.PASS;

    private InteractionResultHelper() {
    }

    public static boolean consumesAction(InteractionResult interactionResult) {
        return interactionResult.consumesAction();
    }

    public static boolean shouldSwing(InteractionResult interactionResult) {
        InteractionResult.Success success;
        return interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).swingSource() != InteractionResult.SwingSource.NONE;
    }

    public static boolean indicateItemUse(InteractionResult interactionResult) {
        InteractionResult.Success success;
        return interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).itemContext().wasItemInteraction();
    }

    public static InteractionResult sidedSuccess(boolean isClientSide) {
        return InteractionResult.SUCCESS;
    }

    public static ItemStack getObject(InteractionResult interactionResult) {
        InteractionResult.Success success;
        return interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).heldItemTransformedTo() != null ? success.heldItemTransformedTo() : ItemStack.EMPTY;
    }

    public static InteractionResult success(ItemStack itemStack) {
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    public static InteractionResult consume(ItemStack itemStack) {
        return InteractionResult.CONSUME;
    }

    public static InteractionResult pass(ItemStack itemStack) {
        return InteractionResult.PASS;
    }

    public static InteractionResult fail(ItemStack itemStack) {
        return InteractionResult.FAIL;
    }

    public static InteractionResult sidedSuccess(ItemStack itemStack, boolean isClientSide) {
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }
}

