/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.util.v1;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class ShapesHelper {
    private ShapesHelper() {
    }

    public static Map<Direction, VoxelShape> rotate(VoxelShape voxelShape) {
        EnumMap<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        for (Direction direction : Direction.values()) {
            shapes.put(direction, ShapesHelper.rotate(direction.getRotation(), voxelShape));
        }
        return Maps.immutableEnumMap(shapes);
    }

    public static Map<Direction, VoxelShape> rotateHorizontally(VoxelShape voxelShape) {
        EnumMap<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Quaternionf rotation = ShapesHelper.getHorizontalRotation(direction);
            shapes.put(direction, ShapesHelper.rotate(rotation, voxelShape));
        }
        return Maps.immutableEnumMap(shapes);
    }

    public static Quaternionf getHorizontalRotation(Direction direction) {
        return new Quaternionf().rotationY((float)Math.atan2(direction.getStepX(), direction.getStepZ()));
    }

    public static VoxelShape rotate(Quaternionf rotation, VoxelShape voxelShape) {
        return ShapesHelper.rotate(rotation, voxelShape, new Vector3d(0.5, 0.5, 0.5));
    }

    public static VoxelShape rotate(Quaternionf rotation, VoxelShape voxelShape, Vector3d originOffset) {
        VoxelShape[] joinedVoxelShape = new VoxelShape[]{Shapes.empty()};
        voxelShape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vector3d start = rotation.transform(new Vector3d(minX, minY, minZ).sub((Vector3dc)originOffset)).add((Vector3dc)originOffset);
            Vector3d end = rotation.transform(new Vector3d(maxX, maxY, maxZ).sub((Vector3dc)originOffset)).add((Vector3dc)originOffset);
            joinedVoxelShape[0] = Shapes.or((VoxelShape)joinedVoxelShape[0], (VoxelShape)ShapesHelper.box(start.x, start.y, start.z, end.x, end.y, end.z));
        });
        return joinedVoxelShape[0];
    }

    public static VoxelShape box(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return Shapes.box((double)Math.min(startX, endX), (double)Math.min(startY, endY), (double)Math.min(startZ, endZ), (double)Math.max(startX, endX), (double)Math.max(startY, endY), (double)Math.max(startZ, endZ));
    }
}

