/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config.annotation;

import fuzs.puzzleslib.impl.config.ConfigDataHolderImpl;
import fuzs.puzzleslib.impl.config.annotation.ConfigEntry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Consumer;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public abstract class ValueEntry<T>
extends ConfigEntry<T> {
    public ValueEntry(Field field) {
        super(field);
    }

    @Override
    public List<String> getComments(@Nullable Object o) {
        List<String> comments = super.getComments(o);
        Object defaultValue = this.getDefaultValue(o);
        comments.add("Default Value: " + (defaultValue != null ? this.getValueString(defaultValue) : null));
        if (this.requiresWorldRestart()) {
            comments.add("Requires Restart: World");
        }
        if (this.requiresGameRestart()) {
            comments.add("Requires Restart: Game");
        }
        return comments;
    }

    protected String getValueString(T value) {
        return value.toString();
    }

    @Override
    public final void defineValue(ModConfigSpec.Builder builder, ConfigDataHolderImpl<?> context, @Nullable Object o) {
        if (Modifier.isFinal(this.field.getModifiers())) {
            throw new RuntimeException("Field must not be final");
        }
        List<String> comments = this.getComments(o);
        builder.comment((String[])comments.toArray(String[]::new));
        if (this.requiresWorldRestart()) {
            builder.worldRestart();
        }
        if (this.requiresGameRestart()) {
            builder.gameRestart();
        }
        ModConfigSpec.ConfigValue<T> configValue = this.getConfigValue(builder, o);
        context.accept(configValue, this.getValueCallback(configValue, o));
    }

    private boolean requiresGameRestart() {
        return this.getAnnotation().gameRestart();
    }

    private boolean requiresWorldRestart() {
        return this.getAnnotation().worldRestart();
    }

    public abstract ModConfigSpec.ConfigValue<T> getConfigValue(ModConfigSpec.Builder var1, @Nullable Object var2);

    private Consumer<T> getValueCallback(ModConfigSpec.ConfigValue<T> configValue, @Nullable Object o) {
        try {
            MethodHandle methodHandle = MethodHandles.lookup().unreflectSetter(this.field);
            return value -> {
                try {
                    methodHandle.invoke(o, configValue.get());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            };
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class BooleanEntry
    extends ValueEntry<Boolean> {
        public BooleanEntry(Field field) {
            super(field);
        }

        public ModConfigSpec.BooleanValue getConfigValue(ModConfigSpec.Builder builder, @Nullable Object o) {
            return builder.define(this.getName(), ((Boolean)this.getDefaultValue(o)).booleanValue());
        }
    }
}

