/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.data.v2.core;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class NeoForgeDataProviderContext
extends DataProviderContext {
    private final ResourceManager clientResourceManager;
    private final ResourceManager serverResourceManager;

    public NeoForgeDataProviderContext(String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, ResourceManager clientResourceManager, ResourceManager serverResourceManager) {
        super(modId, packOutput, registries);
        this.clientResourceManager = clientResourceManager;
        this.serverResourceManager = serverResourceManager;
    }

    public static NeoForgeDataProviderContext fromEvent(GatherDataEvent event) {
        return NeoForgeDataProviderContext.fromEvent(event, event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    public static NeoForgeDataProviderContext fromEvent(GatherDataEvent event, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        return new NeoForgeDataProviderContext(event.getModContainer().getModId(), packOutput, registries, event.getResourceManager(PackType.CLIENT_RESOURCES), event.getResourceManager(PackType.SERVER_DATA));
    }

    @Override
    public ResourceManager getClientResourceManager() {
        return this.clientResourceManager;
    }

    @Override
    public ResourceManager getServerResourceManager() {
        return this.serverResourceManager;
    }

    @Override
    public NeoForgeDataProviderContext withRegistries(CompletableFuture<HolderLookup.Provider> registries) {
        return new NeoForgeDataProviderContext(this.getModId(), this.getPackOutput(), registries, this.clientResourceManager, this.serverResourceManager);
    }

    @FunctionalInterface
    public static interface Factory
    extends Function<NeoForgeDataProviderContext, DataProvider> {
    }
}

