/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.attachment.builder;

import fuzs.puzzleslib.api.attachment.v4.DataAttachmentRegistry;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.impl.attachment.DataAttachmentTypeImpl;
import fuzs.puzzleslib.impl.attachment.builder.DataAttachmentBuilder;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.attachment.NeoForgeAttachmentTypeAdapter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class NeoForgeDataAttachmentBuilder<T extends IAttachmentHolder, V, B extends DataAttachmentRegistry.Builder<T, V, B>>
extends DataAttachmentBuilder<T, V, B> {
    @Override
    public DataAttachmentType<T, V> build(ResourceLocation resourceLocation) {
        DeferredRegister registrar = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)resourceLocation.getNamespace());
        NeoForgeModContainerHelper.getOptionalModEventBus(resourceLocation.getNamespace()).ifPresent(arg_0 -> ((DeferredRegister)registrar).register(arg_0));
        DeferredHolder attachmentType = registrar.register(resourceLocation.getPath(), () -> {
            AttachmentType.Builder builder = AttachmentType.builder(() -> {
                throw new UnsupportedOperationException("Attachment type " + String.valueOf(resourceLocation) + " does not support a default value!");
            });
            this.configureBuilder(resourceLocation, builder);
            return builder.build();
        });
        NeoForgeAttachmentTypeAdapter adapter = new NeoForgeAttachmentTypeAdapter(attachmentType);
        return new DataAttachmentTypeImpl(adapter, x$0 -> this.getRegistryAccess(x$0), this.defaultValues);
    }

    @MustBeInvokedByOverriders
    void configureBuilder(ResourceLocation resourceLocation, AttachmentType.Builder<V> builder) {
        if (this.codec != null) {
            builder.serialize(this.codec.fieldOf(resourceLocation.toString())).copyHandler((value, holder, registries) -> value);
        }
        if (this.streamCodec != null) {
            builder.sync((holder, serverPlayer) -> this.syncWith(holder, (ServerPlayer)serverPlayer), this.streamCodec);
        }
    }
}

