/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractLanguageProvider
implements DataProvider {
    private final ResourceLocation filePath;
    private final PackOutput.PathProvider pathProvider;

    public AbstractLanguageProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String languageCode, DataProviderContext context) {
        this(languageCode, context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String modId, PackOutput packOutput) {
        this("en_us", modId, packOutput);
    }

    public AbstractLanguageProvider(String languageCode, String modId, PackOutput packOutput) {
        this.filePath = ResourceLocationHelper.fromNamespaceAndPath(modId, languageCode);
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang");
    }

    public abstract void addTranslations(TranslationBuilder var1);

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        JsonObject jsonObject = new JsonObject();
        this.addTranslations((translationKey, value) -> {
            Objects.requireNonNull(translationKey, "translation key is null");
            Objects.requireNonNull(value, "value is null");
            if (jsonObject.has(translationKey)) {
                throw new IllegalStateException("Created duplicate translation key: " + translationKey);
            }
            jsonObject.addProperty(translationKey, value);
        });
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), (Registry)BuiltInRegistries.BLOCK, TranslationBuilder::addBlock);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), (Registry)BuiltInRegistries.ITEM, TranslationBuilder::addItem);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), (Registry)BuiltInRegistries.ENTITY_TYPE, TranslationBuilder::addEntityType);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), BuiltInRegistries.ATTRIBUTE, TranslationBuilder::addAttribute);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), BuiltInRegistries.MOB_EFFECT, TranslationBuilder::addMobEffect);
        return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)jsonObject, (Path)this.pathProvider.json(this.filePath));
    }

    private <T> void verifyRequiredTranslationKeys(Predicate<String> predicate, Registry<T> registry, HolderTranslationCollector<T> holderTranslationCollector) {
        registry.listElements().filter(holder -> holder.key().location().getNamespace().equals(this.filePath.getNamespace())).forEach(holder -> holderTranslationCollector.accept((translationKey, value) -> {
            Objects.requireNonNull(translationKey, "translation key is null");
            if (this.mustHaveTranslationKey((Holder.Reference<?>)holder, translationKey) && !predicate.test(translationKey)) {
                throw new IllegalStateException("Missing translation key '%s' for '%s'".formatted(translationKey, holder));
            }
        }, (Holder)holder, ""));
    }

    protected boolean mustHaveTranslationKey(Holder.Reference<?> holder, String translationKey) {
        return true;
    }

    public String getName() {
        return "Language (" + this.filePath.getPath() + ")";
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface TranslationBuilder {
        public void add(String var1, String var2);

        default public void add(String translationKey, String additionalKey, String value) {
            Objects.requireNonNull(additionalKey, "additional key is null");
            this.add(translationKey + (String)(additionalKey.isEmpty() ? "" : "." + additionalKey), value);
        }

        default public void add(ResourceLocation resourceLocation, String value) {
            this.add(resourceLocation, "", value);
        }

        default public void add(ResourceLocation resourceLocation, String additionalKey, String value) {
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.add(resourceLocation.toLanguageKey(), additionalKey, value);
        }

        default public void add(Component component) {
            TranslatableContents contents;
            Objects.requireNonNull(component, "component is null");
            ComponentContents componentContents = component.getContents();
            if (!(componentContents instanceof TranslatableContents) || (contents = (TranslatableContents)componentContents).getFallback() == null) {
                throw new IllegalArgumentException("Unsupported component: " + String.valueOf(component));
            }
            this.add(contents.getKey(), contents.getFallback());
        }

        default public void add(Component component, String value) {
            Objects.requireNonNull(component, "component is null");
            ComponentContents componentContents = component.getContents();
            if (!(componentContents instanceof TranslatableContents)) {
                throw new IllegalArgumentException("Unsupported component: " + String.valueOf(component));
            }
            TranslatableContents contents = (TranslatableContents)componentContents;
            this.add(contents.getKey(), value);
        }

        default public void add(Holder<?> holder, String value) {
            this.add(holder, "", value);
        }

        default public void add(Holder<?> holder, String additionalKey, String value) {
            Objects.requireNonNull(holder, "holder is null");
            this.add((ResourceKey)holder.unwrapKey().orElseThrow(), additionalKey, value);
        }

        default public void add(ResourceKey<?> resourceKey, String value) {
            this.add(resourceKey, "", value);
        }

        default public void add(ResourceKey<?> resourceKey, String additionalKey, String value) {
            Objects.requireNonNull(resourceKey, "resource key is null");
            String registry = Registries.elementsDirPath((ResourceKey)resourceKey.registryKey());
            this.add(registry, resourceKey.location(), additionalKey, value);
        }

        default public void add(String registry, ResourceLocation resourceLocation, String value) {
            this.add(registry, resourceLocation, "", value);
        }

        default public void add(String registry, ResourceLocation resourceLocation, String additionalKey, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.add(resourceLocation.toLanguageKey(registry), additionalKey, value);
        }

        default public void add(TagKey<?> tagKey, String value) {
            Objects.requireNonNull(tagKey, "tag key is null");
            String registry = Registries.elementsDirPath((ResourceKey)tagKey.registry());
            this.add("tag." + tagKey.location().toLanguageKey(registry), value);
        }

        default public BlockFamilyBuilder blockFamily(String blockValue) {
            return new BlockFamilyBuilder(this::add, blockValue);
        }

        default public BlockFamilyBuilder blockFamily(String blockValue, String baseBlockValue) {
            return new BlockFamilyBuilder(this::add, blockValue, baseBlockValue);
        }

        default public void addBlock(Holder<Block> block, String value) {
            Objects.requireNonNull(block, "block is null");
            this.add((Block)block.value(), value);
        }

        default public void add(Block block, String value) {
            this.add(block, "", value);
        }

        default public void add(Block block, String additionalKey, String value) {
            Objects.requireNonNull(block, "block is null");
            this.add(block.getDescriptionId(), additionalKey, value);
        }

        default public void addItem(Holder<Item> item, String value) {
            Objects.requireNonNull(item, "item is null");
            this.add((Item)item.value(), value);
        }

        default public void add(Item item, String value) {
            this.add(item, "", value);
        }

        default public void add(Item item, String additionalKey, String value) {
            Objects.requireNonNull(item, "item is null");
            this.add(item.getDescriptionId(), additionalKey, value);
        }

        default public void addSpawnEgg(Item item, String value) {
            Objects.requireNonNull(item, "item is null");
            if (!(item instanceof SpawnEggItem)) {
                throw new IllegalArgumentException("Unsupported item: " + String.valueOf(item));
            }
            this.add(item, value + " Spawn Egg");
        }

        default public void addMobEffect(Holder<MobEffect> mobEffect, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add((MobEffect)mobEffect.value(), value);
        }

        default public void add(MobEffect mobEffect, String value) {
            this.add(mobEffect, "", value);
        }

        default public void add(MobEffect mobEffect, String additionalKey, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add(mobEffect.getDescriptionId(), additionalKey, value);
        }

        default public void addEntityType(Holder<? extends EntityType<?>> entityType, String value) {
            Objects.requireNonNull(entityType, "entity type is null");
            this.add((EntityType)entityType.value(), value);
        }

        default public void add(EntityType<?> entityType, String value) {
            this.add(entityType, "", value);
        }

        default public void add(EntityType<?> entityType, String additionalKey, String value) {
            Objects.requireNonNull(entityType, "entity type is null");
            this.add(entityType.getDescriptionId(), additionalKey, value);
        }

        default public void addAttribute(Holder<Attribute> attribute, String value) {
            Objects.requireNonNull(attribute, "attribute is null");
            this.add((Attribute)attribute.value(), value);
        }

        default public void add(Attribute attribute, String value) {
            this.add(attribute, "", value);
        }

        default public void add(Attribute attribute, String additionalKey, String value) {
            Objects.requireNonNull(attribute, "attribute is null");
            this.add(attribute.getDescriptionId(), additionalKey, value);
        }

        default public void addStatType(Holder<StatType<?>> statType, String value) {
            Objects.requireNonNull(statType, "stat type is null");
            this.add((StatType)statType.value(), value);
        }

        default public void add(StatType<?> statType, String value) {
            this.add(statType, "", value);
        }

        default public void add(StatType<?> statType, String additionalKey, String value) {
            Objects.requireNonNull(statType, "stat type is null");
            Objects.requireNonNull(statType.getDisplayName(), "component is null");
            ComponentContents componentContents = statType.getDisplayName().getContents();
            if (!(componentContents instanceof TranslatableContents)) {
                throw new IllegalArgumentException("Unsupported component: " + String.valueOf(statType.getDisplayName()));
            }
            TranslatableContents contents = (TranslatableContents)componentContents;
            this.add(contents.getKey(), additionalKey, value);
        }

        default public void addPotion(Holder<Potion> potion, String value) {
            Objects.requireNonNull(potion, "potion is null");
            Function<Item, Component> potionNameGetter = item -> new PotionContents(potion).getName(item.getDescriptionId() + ".effect.");
            this.add(potionNameGetter.apply(Items.TIPPED_ARROW), "Arrow of " + value);
            this.add(potionNameGetter.apply(Items.POTION), "Potion of " + value);
            this.add(potionNameGetter.apply(Items.SPLASH_POTION), "Splash Potion of " + value);
            this.add(potionNameGetter.apply(Items.LINGERING_POTION), "Lingering Potion of " + value);
        }

        default public void addSoundEvent(Holder<SoundEvent> soundEvent, String value) {
            Objects.requireNonNull(soundEvent, "sound event is null");
            this.add((SoundEvent)soundEvent.value(), value);
        }

        default public void add(SoundEvent soundEvent, String value) {
            Objects.requireNonNull(soundEvent, "sound event is null");
            this.add("subtitles." + soundEvent.location().getPath(), value);
        }

        default public void addCreativeModeTab(Holder<CreativeModeTab> creativeModeTab, String value) {
            Objects.requireNonNull(creativeModeTab, "creative mode tab is null");
            this.add((CreativeModeTab)creativeModeTab.value(), value);
        }

        default public void add(CreativeModeTab creativeModeTab, String value) {
            Objects.requireNonNull(creativeModeTab, "creative mode tab is null");
            this.add(creativeModeTab.getDisplayName(), value);
        }

        default public void addBiome(ResourceKey<Biome> biome, String value) {
            Objects.requireNonNull(biome, "biome is null");
            this.add(biome.location().toLanguageKey("biome"), value);
        }

        default public void addGenericDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.location().getPath(), value);
        }

        default public void addPlayerDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.location().getPath() + ".player", value);
        }

        default public void addItemDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.location().getPath() + ".item", value);
        }

        default public void addPaintingVariant(ResourceKey<PaintingVariant> paintingVariant, String title, String author) {
            Objects.requireNonNull(paintingVariant, "painting variant is null");
            this.add(paintingVariant.location().toLanguageKey("painting", "title"), title);
            this.add(paintingVariant.location().toLanguageKey("painting", "author"), author);
        }

        default public void add(KeyMapping keyMapping, String value) {
            Objects.requireNonNull(keyMapping, "key mapping is null");
            this.add(keyMapping.getName(), value);
        }

        default public void addKeyCategory(String modId, String value) {
            this.add(new KeyMapping.Category(ResourceLocationHelper.fromNamespaceAndPath(modId, "main")).label(), value);
        }

        default public void add(GameRules.Key<?> gameRule, String value) {
            this.add(gameRule, "", value);
        }

        default public void addGameRuleDescription(GameRules.Key<?> gameRule, String value) {
            this.add(gameRule, "description", value);
        }

        default public void add(GameRules.Key<?> gameRule, String additionalKey, String value) {
            Objects.requireNonNull(gameRule, "game rule is null");
            this.add(gameRule.getDescriptionId(), additionalKey, value);
        }
    }

    @FunctionalInterface
    protected static interface HolderTranslationCollector<T> {
        public void accept(TranslationBuilder var1, Holder<T> var2, String var3);
    }

    public static class BlockFamilyBuilder {
        static final Map<BlockFamily.Variant, BiFunction<BlockFamilyBuilder, Block, BlockFamilyBuilder>> VARIANT_FUNCTIONS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, BlockFamilyBuilder::button).put((Object)BlockFamily.Variant.CHISELED, BlockFamilyBuilder::chiseled).put((Object)BlockFamily.Variant.CRACKED, BlockFamilyBuilder::cracked).put((Object)BlockFamily.Variant.CUT, BlockFamilyBuilder::cut).put((Object)BlockFamily.Variant.DOOR, BlockFamilyBuilder::door).put((Object)BlockFamily.Variant.CUSTOM_FENCE, BlockFamilyBuilder::fence).put((Object)BlockFamily.Variant.FENCE, BlockFamilyBuilder::fence).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, BlockFamilyBuilder::fenceGate).put((Object)BlockFamily.Variant.FENCE_GATE, BlockFamilyBuilder::fenceGate).put((Object)BlockFamily.Variant.MOSAIC, BlockFamilyBuilder::mosaic).put((Object)BlockFamily.Variant.SIGN, BlockFamilyBuilder::sign).put((Object)BlockFamily.Variant.SLAB, BlockFamilyBuilder::slab).put((Object)BlockFamily.Variant.STAIRS, BlockFamilyBuilder::stairs).put((Object)BlockFamily.Variant.PRESSURE_PLATE, BlockFamilyBuilder::pressurePlate).put((Object)BlockFamily.Variant.POLISHED, BlockFamilyBuilder::polished).put((Object)BlockFamily.Variant.TRAPDOOR, BlockFamilyBuilder::trapdoor).put((Object)BlockFamily.Variant.WALL, BlockFamilyBuilder::wall).build();
        private final BiConsumer<Block, String> valueConsumer;
        private final String blockValue;
        private final String baseBlockValue;

        private BlockFamilyBuilder(BiConsumer<Block, String> valueConsumer, String blockValue) {
            this(valueConsumer, blockValue, blockValue);
        }

        private BlockFamilyBuilder(BiConsumer<Block, String> valueConsumer, String blockValue, String baseBlockValue) {
            this.valueConsumer = valueConsumer;
            this.blockValue = blockValue;
            this.baseBlockValue = baseBlockValue;
        }

        public void generateFor(BlockFamily blockFamily) {
            this.baseBlock(blockFamily.getBaseBlock());
            blockFamily.getVariants().forEach((variant, block) -> {
                BiFunction<BlockFamilyBuilder, Block, BlockFamilyBuilder> variantFunction = VARIANT_FUNCTIONS.get(variant);
                if (variantFunction != null) {
                    variantFunction.apply(this, (Block)block);
                }
            });
        }

        public BlockFamilyBuilder baseBlock(Block block) {
            this.valueConsumer.accept(block, this.baseBlockValue);
            return this;
        }

        public BlockFamilyBuilder button(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Button");
            return this;
        }

        public BlockFamilyBuilder chiseled(Block block) {
            this.valueConsumer.accept(block, "Chiseled " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cracked(Block block) {
            this.valueConsumer.accept(block, "Cracked " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cut(Block block) {
            this.valueConsumer.accept(block, "Cut " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder door(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Door");
            return this;
        }

        public BlockFamilyBuilder fence(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence");
            return this;
        }

        public BlockFamilyBuilder fenceGate(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence Gate");
            return this;
        }

        public BlockFamilyBuilder mosaic(Block block) {
            this.valueConsumer.accept(block, "Mosaic " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder sign(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Sign");
            return this;
        }

        public BlockFamilyBuilder slab(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Slab");
            return this;
        }

        public BlockFamilyBuilder hangingSign(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Hanging Sign");
            return this;
        }

        public BlockFamilyBuilder stairs(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Stairs");
            return this;
        }

        public BlockFamilyBuilder pressurePlate(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Pressure Plate");
            return this;
        }

        public BlockFamilyBuilder polished(Block block) {
            this.valueConsumer.accept(block, "Polished " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder trapdoor(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Trapdoor");
            return this;
        }

        public BlockFamilyBuilder wall(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Wall");
            return this;
        }
    }
}

