/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractParticleProvider
implements DataProvider {
    public static final Codec<ParticleDescription> CODEC = ResourceLocation.CODEC.listOf().fieldOf("textures").xmap(ParticleDescription::new, ParticleDescription::getTextures).codec();
    private final Map<ResourceLocation, ParticleDescription> values = new LinkedHashMap<ResourceLocation, ParticleDescription>();
    private final PackOutput.PathProvider pathProvider;
    @Nullable
    private final ResourceManager clientResourceManager;

    public AbstractParticleProvider(DataProviderContext context) {
        this(context.getPackOutput(), context.getClientResourceManager());
    }

    public AbstractParticleProvider(PackOutput packOutput, @Nullable ResourceManager clientResourceManager) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "particles");
        this.clientResourceManager = clientResourceManager;
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        this.addParticles();
        return DataProvider.saveAll((CachedOutput)cachedOutput, CODEC, (PackOutput.PathProvider)this.pathProvider, this.values);
    }

    public abstract void addParticles();

    public void add(ParticleType<?> particleType) {
        this.add(particleType, -1);
    }

    public void add(ParticleType<?> particleType, int indexEnd) {
        this.add(particleType, BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), indexEnd);
    }

    public void add(ParticleType<?> particleType, int indexStart, int indexEnd) {
        this.add(particleType, BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), indexStart, indexEnd);
    }

    public void add(ParticleType<?> particleType, ResourceLocation resourceLocation, int indexEnd) {
        this.add(BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), resourceLocation, indexEnd);
    }

    public void add(ParticleType<?> particleType, ResourceLocation resourceLocation, int indexStart, int indexEnd) {
        this.add(BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), resourceLocation, indexStart, indexEnd);
    }

    public void add(ResourceLocation id, ResourceLocation resourceLocation, int indexEnd) {
        this.add(id, resourceLocation, 0, indexEnd);
    }

    public void add(ResourceLocation id, ResourceLocation resourceLocation, int indexStart, int indexEnd) {
        if (indexEnd == -1) {
            this.add(id, new ParticleDescription(Collections.singletonList(resourceLocation)));
        } else {
            List textures = IntStream.rangeClosed(Math.min(indexStart, indexEnd), Math.max(indexStart, indexEnd)).mapToObj(index -> ResourceLocationHelper.fromNamespaceAndPath(resourceLocation.getNamespace(), resourceLocation.getPath() + "_" + index)).collect(Collectors.toList());
            if (indexEnd < indexStart) {
                Collections.reverse(textures);
            }
            this.add(id, new ParticleDescription(textures));
        }
    }

    public void add(ResourceLocation id, ParticleDescription particleDescription) {
        if (this.clientResourceManager != null) {
            this.validate(id, particleDescription, this.clientResourceManager);
        }
        if (this.values.putIfAbsent(id, particleDescription) != null) {
            throw new IllegalStateException("Duplicate particle description: " + String.valueOf(id));
        }
    }

    protected void validate(ResourceLocation id, ParticleDescription particleDescription, ResourceManager resourceManager) {
        Objects.requireNonNull(resourceManager, "resource manager is null");
        List<String> missingTextures = particleDescription.getTextures().stream().filter(resourceLocation -> resourceManager.getResource(resourceLocation.withPath(string -> "textures/particle/" + string + ".png")).isEmpty()).map(ResourceLocation::toString).toList();
        if (!missingTextures.isEmpty()) {
            throw new IllegalArgumentException("Couldn't define particle description %s as it is missing following texture(s): %s".formatted(id, String.join((CharSequence)",", missingTextures)));
        }
    }

    public String getName() {
        return "Particle Descriptions";
    }
}

