/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.renderer.v1.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import fuzs.puzzleslib.impl.client.core.proxy.ClientProxyImpl;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class QuadUtils {
    public static final int VERTEX_STRIDE = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    public static final int VERTEX_POSITION = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.POSITION) / 4;
    public static final int VERTEX_COLOR = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.COLOR) / 4;
    public static final int VERTEX_UV = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV) / 4;
    public static final int VERTEX_UV0 = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV0) / 4;
    public static final int VERTEX_UV1 = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV1) / 4;
    public static final int VERTEX_UV2 = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV2) / 4;
    public static final int VERTEX_NORMAL = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.NORMAL) / 4;

    private QuadUtils() {
    }

    public static BakedQuad copy(BakedQuad bakedQuad) {
        return ClientProxyImpl.get().copyBakedQuad(bakedQuad);
    }

    public static Vector3f getPosition(BakedQuad bakedQuad, int vertexIndex) {
        return new Vector3f(QuadUtils.getX(bakedQuad, vertexIndex), QuadUtils.getY(bakedQuad, vertexIndex), QuadUtils.getZ(bakedQuad, vertexIndex));
    }

    public static float getX(BakedQuad bakedQuad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_POSITION;
        return Float.intBitsToFloat(bakedQuad.vertices()[offset]);
    }

    public static float getY(BakedQuad bakedQuad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_POSITION;
        return Float.intBitsToFloat(bakedQuad.vertices()[offset + 1]);
    }

    public static float getZ(BakedQuad bakedQuad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_POSITION;
        return Float.intBitsToFloat(bakedQuad.vertices()[offset + 2]);
    }

    public static Vector3f getNormal(BakedQuad bakedQuad, int vertexIndex) {
        return new Vector3f(QuadUtils.getNormalX(bakedQuad, vertexIndex), QuadUtils.getNormalY(bakedQuad, vertexIndex), QuadUtils.getNormalZ(bakedQuad, vertexIndex));
    }

    public static float getNormalX(BakedQuad bakedQuad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_NORMAL;
        int normal = bakedQuad.vertices()[offset];
        return (float)((byte)(normal & 0xFF)) / 127.0f;
    }

    public static float getNormalY(BakedQuad bakedQuad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_NORMAL;
        int normal = bakedQuad.vertices()[offset];
        return (float)((byte)(normal >> 8 & 0xFF)) / 127.0f;
    }

    public static float getNormalZ(BakedQuad bakedQuad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_NORMAL;
        int normal = bakedQuad.vertices()[offset];
        return (float)((byte)(normal >> 16 & 0xFF)) / 127.0f;
    }

    public static int getColor(BakedQuad bakedQuad, int vertexIndex) {
        return bakedQuad.vertices()[vertexIndex * VERTEX_STRIDE + VERTEX_COLOR];
    }

    public static Vector2f getUv(BakedQuad bakedQuad, int vertexIndex) {
        return new Vector2f(QuadUtils.getU(bakedQuad, vertexIndex), QuadUtils.getV(bakedQuad, vertexIndex));
    }

    public static float getU(BakedQuad bakedQuad, int vertexIndex) {
        return Float.intBitsToFloat(bakedQuad.vertices()[vertexIndex * VERTEX_STRIDE + VERTEX_UV]);
    }

    public static float getV(BakedQuad bakedQuad, int vertexIndex) {
        return Float.intBitsToFloat(bakedQuad.vertices()[vertexIndex * VERTEX_STRIDE + VERTEX_UV + 1]);
    }

    public static void setPosition(BakedQuad bakedQuad, int vertexIndex, Vector3f position) {
        QuadUtils.setPosition(bakedQuad, vertexIndex, position.x, position.y, position.z);
    }

    public static void setPosition(BakedQuad bakedQuad, int vertexIndex, float x, float y, float z) {
        QuadUtils.setX(bakedQuad, vertexIndex, x);
        QuadUtils.setY(bakedQuad, vertexIndex, y);
        QuadUtils.setZ(bakedQuad, vertexIndex, z);
    }

    public static void setX(BakedQuad bakedQuad, int vertexIndex, float x) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_POSITION;
        bakedQuad.vertices()[offset] = Float.floatToRawIntBits(x);
    }

    public static void setY(BakedQuad bakedQuad, int vertexIndex, float y) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_POSITION;
        bakedQuad.vertices()[offset + 1] = Float.floatToRawIntBits(y);
    }

    public static void setZ(BakedQuad bakedQuad, int vertexIndex, float z) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_POSITION;
        bakedQuad.vertices()[offset + 2] = Float.floatToRawIntBits(z);
    }

    public static void setNormal(BakedQuad bakedQuad, int vertexIndex, Vector3f normal) {
        QuadUtils.setNormal(bakedQuad, vertexIndex, normal.x, normal.y, normal.z);
    }

    public static void setNormal(BakedQuad bakedQuad, int vertexIndex, float x, float y, float z) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_NORMAL;
        bakedQuad.vertices()[offset] = (int)(x * 127.0f) & 0xFF | ((int)(y * 127.0f) & 0xFF) << 8 | ((int)(z * 127.0f) & 0xFF) << 16;
    }

    public static void setColor(BakedQuad bakedQuad, int vertexIndex, int r, int g, int b, int a) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_COLOR;
        bakedQuad.vertices()[offset] = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
    }

    public static void setUv(BakedQuad bakedQuad, int vertexIndex, Vector2f uv) {
        QuadUtils.setUv(bakedQuad, vertexIndex, uv.x, uv.y);
    }

    public static void setUv(BakedQuad bakedQuad, int vertexIndex, float u, float v) {
        QuadUtils.setU(bakedQuad, vertexIndex, u);
        QuadUtils.setU(bakedQuad, vertexIndex, v);
    }

    public static void setU(BakedQuad bakedQuad, int vertexIndex, float u) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_UV;
        bakedQuad.vertices()[offset] = Float.floatToRawIntBits(u);
    }

    public static void setV(BakedQuad bakedQuad, int vertexIndex, float v) {
        int offset = vertexIndex * VERTEX_STRIDE + VERTEX_UV;
        bakedQuad.vertices()[offset + 1] = Float.floatToRawIntBits(v);
    }

    public static void fillNormal(BakedQuad bakedQuad) {
        Vector3f v0 = QuadUtils.getPosition(bakedQuad, 0);
        Vector3f v1 = QuadUtils.getPosition(bakedQuad, 1);
        Vector3f v2 = QuadUtils.getPosition(bakedQuad, 2);
        Vector3f v3 = QuadUtils.getPosition(bakedQuad, 3);
        v3.sub((Vector3fc)v1);
        v2.sub((Vector3fc)v0);
        v2.cross((Vector3fc)v3);
        v2.normalize();
        for (int i = 0; i < 4; ++i) {
            QuadUtils.setNormal(bakedQuad, i, v2);
        }
    }
}

