/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.tags;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

@FunctionalInterface
public interface TagFactory {
    public static final TagFactory MINECRAFT = TagFactory.make("minecraft");
    public static final TagFactory COMMON = TagFactory.make("c");
    public static final TagFactory FABRIC = TagFactory.make("fabric");
    public static final TagFactory NEOFORGE = TagFactory.make("neoforge");

    public static TagFactory make(String modId) {
        return () -> modId;
    }

    public String modId();

    default public <T> TagKey<T> registerTagKey(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return TagKey.create(registryKey, (ResourceLocation)ResourceLocationHelper.fromNamespaceAndPath(this.modId(), path));
    }

    default public TagKey<Block> registerBlockTag(String path) {
        return this.registerTagKey(Registries.BLOCK, path);
    }

    default public TagKey<Item> registerItemTag(String path) {
        return this.registerTagKey(Registries.ITEM, path);
    }

    default public TagKey<Fluid> registerFluidTag(String path) {
        return this.registerTagKey(Registries.FLUID, path);
    }

    default public TagKey<EntityType<?>> registerEntityTypeTag(String path) {
        return this.registerTagKey(Registries.ENTITY_TYPE, path);
    }

    default public TagKey<Enchantment> registerEnchantmentTag(String path) {
        return this.registerTagKey(Registries.ENCHANTMENT, path);
    }

    default public TagKey<Biome> registerBiomeTag(String path) {
        return this.registerTagKey(Registries.BIOME, path);
    }

    default public TagKey<GameEvent> registerGameEventTag(String path) {
        return this.registerTagKey(Registries.GAME_EVENT, path);
    }

    default public TagKey<DamageType> registerDamageTypeTag(String path) {
        return this.registerTagKey(Registries.DAMAGE_TYPE, path);
    }
}

