/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.block.Block;

public final class ToolMaterialFactory {
    private ToolMaterialFactory() {
    }

    public static ToolMaterial createToolMaterial(int miningLevel, int itemDurability, float miningSpeed, float attackDamageBonus, int enchantmentValue, TagKey<Item> repairItems) {
        return ToolMaterialFactory.createToolMaterial(ToolMaterialFactory.getVanillaMiningLevelBlockTag(miningLevel), itemDurability, miningSpeed, attackDamageBonus, enchantmentValue, repairItems);
    }

    public static ToolMaterial createToolMaterial(TagKey<Block> incorrectBlocksForDrops, int itemDurability, float miningSpeed, float attackDamageBonus, int enchantmentValue, TagKey<Item> repairItems) {
        return new ToolMaterial(incorrectBlocksForDrops, itemDurability, miningSpeed, attackDamageBonus, enchantmentValue, repairItems);
    }

    public static TagKey<Block> getVanillaMiningLevelBlockTag(int miningLevel) {
        return switch (miningLevel) {
            case 0 -> BlockTags.INCORRECT_FOR_WOODEN_TOOL;
            case 1 -> BlockTags.INCORRECT_FOR_STONE_TOOL;
            case 2 -> BlockTags.INCORRECT_FOR_IRON_TOOL;
            case 3 -> BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
            case 4 -> BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
            default -> throw new IllegalArgumentException("Unsupported mining level: " + miningLevel);
        };
    }
}

