/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.impl.attachment.AttachmentTypeAdapter;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.RegistryAccess;
import org.jetbrains.annotations.Nullable;

public final class DataAttachmentTypeImpl<T, V>
implements DataAttachmentType<T, V> {
    private final AttachmentTypeAdapter<T, V> attachmentType;
    private final Function<T, RegistryAccess> registryAccessExtractor;
    private final Map<Predicate<T>, Function<RegistryAccess, V>> defaultValues;

    public DataAttachmentTypeImpl(AttachmentTypeAdapter<T, V> attachmentType, Function<T, RegistryAccess> registryAccessExtractor, Map<Predicate<T>, Function<RegistryAccess, V>> defaultValues) {
        this.attachmentType = attachmentType;
        this.registryAccessExtractor = registryAccessExtractor;
        this.defaultValues = ImmutableMap.copyOf(defaultValues);
    }

    @Nullable
    private V getDefaultValue(T holder) {
        for (Map.Entry<Predicate<T>, Function<RegistryAccess, V>> entry : this.defaultValues.entrySet()) {
            if (!entry.getKey().test(holder)) continue;
            return entry.getValue().apply(this.registryAccessExtractor.apply(holder));
        }
        return null;
    }

    @Override
    @Nullable
    public V get(T holder) {
        V defaultValue;
        if (!this.attachmentType.hasData(holder) && (defaultValue = this.getDefaultValue(holder)) != null) {
            this.attachmentType.setData(holder, defaultValue);
        }
        if (this.attachmentType.hasData(holder)) {
            V value = this.attachmentType.getData(holder);
            Objects.requireNonNull(value, () -> "value for " + String.valueOf(this.attachmentType.resourceLocation()) + " is null");
            return value;
        }
        return null;
    }

    @Override
    public V getOrDefault(T holder, V defaultValue) {
        V value = this.get(holder);
        return value != null ? value : defaultValue;
    }

    @Override
    public boolean has(T holder) {
        return this.attachmentType.hasData(holder) || this.getDefaultValue(holder) != null;
    }

    @Override
    public void set(T holder, @Nullable V newValue) {
        V oldValue = this.attachmentType.getData(holder);
        if (!Objects.equals(oldValue, newValue)) {
            if (newValue != null) {
                this.attachmentType.setData(holder, newValue);
            } else {
                this.attachmentType.removeData(holder);
            }
        }
    }

    @Override
    public void update(T holder, UnaryOperator<V> valueUpdater) {
        this.set(holder, valueUpdater.apply(this.get(holder)));
    }
}

