/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.container;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public interface SlotsProvider {
    public static SlotsProvider of(final Container container) {
        return new SlotsProvider(){

            @Override
            public int getContainerSize() {
                return container.getContainerSize();
            }

            @Override
            public ItemStack getItem(int slot) {
                return container.getItem(slot);
            }

            @Override
            public void setItem(int slot, ItemStack itemStack) {
                container.setItem(slot, itemStack);
            }

            @Override
            public void clearContent() {
                container.clearContent();
            }
        };
    }

    public static SlotsProvider of(final NonNullList<ItemStack> items) {
        return new SlotsProvider(){

            @Override
            public int getContainerSize() {
                return items.size();
            }

            @Override
            public ItemStack getItem(int slot) {
                return (ItemStack)items.get(slot);
            }

            @Override
            public void setItem(int slot, ItemStack itemStack) {
                items.set(slot, (Object)itemStack);
            }

            @Override
            public void clearContent() {
                items.clear();
            }
        };
    }

    public int getContainerSize();

    public ItemStack getItem(int var1);

    public void setItem(int var1, ItemStack var2);

    public void clearContent();
}

