/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.init;

import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;

public record NeoForgePotionBrewingBuilder(PotionBrewing.Builder builder) implements RegisterPotionBrewingMixesCallback.Builder
{
    @Override
    public void registerPotionContainer(PotionItem item) {
        Objects.requireNonNull(item, "container item is null");
        this.builder.addContainer((Item)item);
    }

    @Override
    public void registerContainerRecipe(PotionItem inputItem, Ingredient ingredient, PotionItem outputItem) {
        Objects.requireNonNull(inputItem, "input item is null");
        Objects.requireNonNull(ingredient, "ingredient is null");
        Objects.requireNonNull(outputItem, "output item is null");
        if (inputItem.isEnabled(this.builder.enabledFeatures) && outputItem.isEnabled(this.builder.enabledFeatures)) {
            PotionBrewing.Mix mix = new PotionBrewing.Mix(BuiltInRegistries.ITEM.wrapAsHolder((Object)inputItem), ingredient, BuiltInRegistries.ITEM.wrapAsHolder((Object)outputItem));
            this.builder.containerMixes.add(mix);
        }
    }

    @Override
    public void registerPotionRecipe(Holder<Potion> intputPotion, Ingredient ingredient, Holder<Potion> outputPotion) {
        Objects.requireNonNull(intputPotion, "input potion is null");
        Objects.requireNonNull(ingredient, "ingredient is null");
        Objects.requireNonNull(outputPotion, "output potion is null");
        if (((Potion)intputPotion.value()).isEnabled(this.builder.enabledFeatures) && ((Potion)outputPotion.value()).isEnabled(this.builder.enabledFeatures)) {
            PotionBrewing.Mix mix = new PotionBrewing.Mix(intputPotion, ingredient, outputPotion);
            this.builder.potionMixes.add(mix);
        }
    }
}

