/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public final class CreativeModeTabHelper {
    static final Collection<class_1792> POTION_ITEMS = ImmutableSet.of((Object)class_1802.field_8574, (Object)class_1802.field_8436, (Object)class_1802.field_8150, (Object)class_1802.field_8087);

    private CreativeModeTabHelper() {
    }

    public static class_2561 getTitle(class_2960 resourceLocation) {
        String translationKey = "itemGroup.%s.%s".formatted(resourceLocation.method_12836(), resourceLocation.method_12832());
        return class_2561.method_43471((String)translationKey);
    }

    public static class_1761.class_7914 getDisplayItems(String modId) {
        return (itemDisplayParameters, output) -> {
            CreativeModeTabHelper.generateItemTypes(modId, itemDisplayParameters, output);
            CreativeModeTabHelper.generateEnchantmentBookTypes(modId, itemDisplayParameters, output);
            CreativeModeTabHelper.generatePotionEffectTypes(modId, itemDisplayParameters, output);
            CreativeModeTabHelper.generatePaintingTypes(modId, itemDisplayParameters, output);
        };
    }

    public static void generateItemTypes(String modId, class_1761.class_8128 itemDisplayParameters, class_1761.class_7704 output) {
        itemDisplayParameters.comp_1253().method_46759(class_7924.field_41197).ifPresent(registryLookup -> registryLookup.method_42017().filter(holder -> holder.method_40237().method_29177().method_12836().equals(modId)).map(class_1799::new).forEach(itemStack -> output.method_45417(itemStack, class_1761.class_7705.field_40191)));
    }

    public static void generateEnchantmentBookTypes(String modId, class_1761.class_8128 itemDisplayParameters, class_1761.class_7704 output) {
        itemDisplayParameters.comp_1253().method_46759(class_7924.field_41265).ifPresent(registryLookup -> class_7706.method_45428((itemStack, tabVisibility) -> {
            if (((class_9304)itemStack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385)).method_57534().stream().findAny().flatMap(class_6880::method_40230).map(class_5321::method_29177).map(class_2960::method_12836).filter(modId::equals).isPresent()) {
                output.method_45417(itemStack, tabVisibility);
            }
        }, (class_7225)registryLookup, (class_1761.class_7705)class_1761.class_7705.field_40192));
    }

    public static void generatePotionEffectTypes(String modId, class_1761.class_8128 itemDisplayParameters, class_1761.class_7704 output) {
        itemDisplayParameters.comp_1253().method_46759(class_7924.field_41215).ifPresent(registryLookup -> {
            for (class_1792 item : POTION_ITEMS) {
                class_7706.method_45427((itemStack, tabVisibility) -> {
                    if (((class_1844)itemStack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378().flatMap(class_6880::method_40230).map(class_5321::method_29177).map(class_2960::method_12836).filter(modId::equals).isPresent()) {
                        output.method_45417(itemStack, tabVisibility);
                    }
                }, (class_7225)registryLookup, (class_1792)item, (class_1761.class_7705)class_1761.class_7705.field_40191, (class_7699)itemDisplayParameters.comp_1251());
            }
        });
    }

    public static void generatePaintingTypes(String modId, class_1761.class_8128 itemDisplayParameters, class_1761.class_7704 output) {
        itemDisplayParameters.comp_1253().method_46759(class_7924.field_41209).ifPresent(registryLookup -> class_7706.method_48937((class_1761.class_7704)output, (class_7225.class_7874)itemDisplayParameters.comp_1253(), (class_7225.class_7226)registryLookup, holder -> holder.method_40230().map(class_5321::method_29177).map(class_2960::method_12836).filter(modId::equals).isPresent(), (class_1761.class_7705)class_1761.class_7705.field_40191));
    }
}

