/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.impl.client.gui.SingleTextureAtlasSprite;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class GuiGraphicsHelper {
    private GuiGraphicsHelper() {
    }

    public static GuiGraphics create(PoseStack poseStack) {
        return GuiGraphicsHelper.create(poseStack.last().pose());
    }

    public static GuiGraphics create(Matrix4f matrix4f) {
        Minecraft minecraft = Minecraft.getInstance();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, minecraft.renderBuffers().bufferSource());
        guiGraphics.pose().mulPose(matrix4f);
        return guiGraphics;
    }

    public static void fillFrame(GuiGraphics guiGraphics, int posX, int posY, int width, int height, int borderSize, int color) {
        GuiGraphicsHelper.fillFrame(guiGraphics, posX, posY, width, height, borderSize, 0, color);
    }

    public static void fillFrame(GuiGraphics guiGraphics, int posX, int posY, int width, int height, int borderSize, int blitOffset, int color) {
        GuiGraphicsHelper.fillFrameArea(guiGraphics, posX, posY, posX + width, posY + height, borderSize, blitOffset, color);
    }

    public static void fillFrameArea(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY, int borderSize, int blitOffset, int color) {
        guiGraphics.fill(minX, minY, maxX, minY + borderSize, blitOffset, color);
        guiGraphics.fill(minX, maxY - borderSize, maxX, maxY, blitOffset, color);
        guiGraphics.fill(minX, minY + borderSize, minX + borderSize, maxY - borderSize, blitOffset, color);
        guiGraphics.fill(maxX - borderSize, minY + borderSize, maxX, maxY - borderSize, blitOffset, color);
    }

    public static void fillFrameArea(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY, int borderSize, int color) {
        GuiGraphicsHelper.fillFrameArea(guiGraphics, minX, minY, maxX, maxY, borderSize, 0, color);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation resourceLocation, int x, int y, int width, int height, int borderSize, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderType, resourceLocation, x, y, width, height, borderSize, borderSize, spriteWidth, spriteHeight, uOffset, vOffset);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation resourceLocation, int x, int y, int width, int height, int borderWidth, int borderHeight, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderType, resourceLocation, x, y, width, height, borderWidth, borderHeight, borderWidth, borderHeight, spriteWidth, spriteHeight, uOffset, vOffset);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation resourceLocation, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderType, resourceLocation, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, spriteWidth, spriteHeight, uOffset, vOffset, -1);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation resourceLocation, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int color) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderType, resourceLocation, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, spriteWidth, spriteHeight, uOffset, vOffset, 256, 256, color);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation resourceLocation, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderType, resourceLocation, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, spriteWidth, spriteHeight, uOffset, vOffset, textureWidth, textureHeight, -1);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation resourceLocation, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int textureWidth, int textureHeight, int color) {
        SingleTextureAtlasSprite textureAtlasSprite = new SingleTextureAtlasSprite(resourceLocation, spriteWidth, spriteHeight, uOffset, vOffset, textureWidth, textureHeight);
        GuiSpriteScaling.NineSlice nineSlice = new GuiSpriteScaling.NineSlice(spriteWidth, spriteHeight, new GuiSpriteScaling.NineSlice.Border(borderLeft, borderTop, borderRight, borderBottom), false);
        guiGraphics.blitNineSlicedSprite(renderType, (TextureAtlasSprite)textureAtlasSprite, nineSlice, x, y, width, height, color);
    }

    public static void blitNineSlicedSprite(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation sprite, int x, int y, int width, int height, int borderSize) {
        GuiGraphicsHelper.blitNineSlicedSprite(guiGraphics, renderType, sprite, x, y, width, height, borderSize, borderSize, borderSize, borderSize, -1);
    }

    public static void blitNineSlicedSprite(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation sprite, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom) {
        GuiGraphicsHelper.blitNineSlicedSprite(guiGraphics, renderType, sprite, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, -1);
    }

    public static void blitNineSlicedSprite(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation sprite, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int color) {
        TextureAtlasSprite textureAtlasSprite = Minecraft.getInstance().getGuiSprites().getSprite(sprite);
        GuiSpriteScaling.NineSlice nineSlice = new GuiSpriteScaling.NineSlice(textureAtlasSprite.contents().width(), textureAtlasSprite.contents().height(), new GuiSpriteScaling.NineSlice.Border(borderLeft, borderTop, borderRight, borderBottom), false);
        guiGraphics.blitNineSlicedSprite(renderType, textureAtlasSprite, nineSlice, x, y, width, height, color);
    }

    public static void blitTiledSprite(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation sprite, int x, int y, int width, int height, int spriteWidth, int spriteHeight) {
        GuiGraphicsHelper.blitTiledSprite(guiGraphics, renderType, sprite, x, y, width, height, spriteWidth, spriteHeight, -1);
    }

    public static void blitTiledSprite(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation sprite, int x, int y, int width, int height, int spriteWidth, int spriteHeight, int color) {
        GuiGraphicsHelper.blitTiledSprite(guiGraphics, renderType, sprite, x, y, width, height, spriteWidth, spriteHeight, 0, 0, color);
    }

    public static void blitTiledSprite(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderType, ResourceLocation sprite, int x, int y, int width, int height, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int color) {
        Minecraft minecraft = Minecraft.getInstance();
        TextureAtlasSprite textureatlassprite = minecraft.getGuiSprites().getSprite(sprite);
        guiGraphics.blitTiledSprite(renderType, textureatlassprite, x, y, width, height, uOffset, vOffset, spriteWidth, spriteHeight, spriteWidth, spriteHeight, color);
    }
}

