/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.renderer.v1;

import fuzs.puzzleslib.impl.client.core.ClientFactories;
import java.util.Objects;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record RenderPropertyKey<T>(ResourceLocation resourceLocation) {
    @Deprecated(forRemoval=true)
    @NotNull
    public static <T> T getRenderProperty(EntityRenderState renderState, RenderPropertyKey<T> key) {
        T renderProperty = RenderPropertyKey.get(renderState, key);
        Objects.requireNonNull(renderProperty, "render property " + String.valueOf(key) + " is null");
        return renderProperty;
    }

    @Deprecated(forRemoval=true)
    public static <T> boolean containsRenderProperty(EntityRenderState renderState, RenderPropertyKey<T> key) {
        return RenderPropertyKey.has(renderState, key);
    }

    @Deprecated(forRemoval=true)
    public static <T> void setRenderProperty(EntityRenderState renderState, RenderPropertyKey<T> key, @Nullable T t) {
        if (t == null) {
            RenderPropertyKey.remove(renderState, key);
        } else {
            RenderPropertyKey.set(renderState, key, t);
        }
    }

    @Nullable
    public static <T> T get(EntityRenderState renderState, RenderPropertyKey<T> key) {
        return ClientFactories.INSTANCE.getRenderProperty(renderState, key);
    }

    public static <T> T getOrDefault(EntityRenderState renderState, RenderPropertyKey<T> key, T defaultProperty) {
        T renderProperty = ClientFactories.INSTANCE.getRenderProperty(renderState, key);
        return renderProperty != null ? renderProperty : defaultProperty;
    }

    public static <T> boolean has(EntityRenderState renderState, RenderPropertyKey<T> key) {
        return ClientFactories.INSTANCE.getRenderProperty(renderState, key) != null;
    }

    public static <T> void set(EntityRenderState renderState, RenderPropertyKey<T> key, T renderProperty) {
        Objects.requireNonNull(renderProperty, "render property is null");
        ClientFactories.INSTANCE.setRenderProperty(renderState, key, renderProperty);
    }

    public static <T> void remove(EntityRenderState renderState, RenderPropertyKey<T> key) {
        ClientFactories.INSTANCE.setRenderProperty(renderState, key, null);
    }
}

