/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2.core;

import com.google.common.base.Suppliers;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;

public class DataProviderContext {
    private final String modId;
    private final PackOutput packOutput;
    private final Supplier<CompletableFuture<HolderLookup.Provider>> registries;

    protected DataProviderContext(String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        this(modId, packOutput, () -> registries);
    }

    private DataProviderContext(String modId, PackOutput packOutput, Supplier<CompletableFuture<HolderLookup.Provider>> registries) {
        this.modId = modId;
        this.packOutput = packOutput;
        this.registries = registries;
    }

    public static DataProviderContext ofPath(String modId) {
        return DataProviderContext.ofPath(modId, Path.of("", new String[0]));
    }

    public static DataProviderContext ofPath(String modId, Path path) {
        return new DataProviderContext(modId, new PackOutput(path), (Supplier<CompletableFuture<HolderLookup.Provider>>)Suppliers.memoize(() -> CompletableFuture.supplyAsync(VanillaRegistries::createLookup, (Executor)Util.backgroundExecutor())));
    }

    public String getModId() {
        return this.modId;
    }

    public PackOutput getPackOutput() {
        return this.packOutput;
    }

    public CompletableFuture<HolderLookup.Provider> getRegistries() {
        return this.registries.get();
    }

    public DataProviderContext withRegistries(CompletableFuture<HolderLookup.Provider> registries) {
        return new DataProviderContext(this.modId, this.packOutput, registries);
    }

    @FunctionalInterface
    public static interface Factory
    extends Function<DataProviderContext, DataProvider> {
    }
}

