/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.override;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.ApiStatus;

public final class CommandOverrides {
    private static final String KEY_PLAYER_SEEN_WORLD = PuzzlesLibMod.id("has_seen_world").toLanguageKey();
    private static final Map<CommandEnvironment, Collection<String>> COMMAND_OVERRIDES = Maps.newEnumMap(CommandEnvironment.class);

    private CommandOverrides() {
    }

    public static void registerServerCommand(String command, boolean onlyDedicated) {
        CommandEnvironment commandEnvironment = onlyDedicated ? CommandEnvironment.DEDICATED_SERVER : CommandEnvironment.SERVER;
        COMMAND_OVERRIDES.computeIfAbsent(commandEnvironment, $ -> new LinkedHashSet()).add(command);
    }

    public static void registerEffectCommand(Holder<MobEffect> holder) {
        CommandOverrides.registerPlayerCommand("effect give @s " + holder.getRegisteredName() + " infinite 127 true", false);
    }

    public static void registerPlayerCommand(String command, boolean onlyDedicated) {
        CommandEnvironment commandEnvironment = onlyDedicated ? CommandEnvironment.DEDICATED_PLAYER : CommandEnvironment.PLAYER;
        COMMAND_OVERRIDES.computeIfAbsent(commandEnvironment, $ -> new LinkedHashSet()).add(command);
    }

    @ApiStatus.Internal
    public static void registerEventHandlers() {
        ServerLifecycleEvents.STARTED.register(server -> {
            if (server.overworld().getGameTime() == 0L) {
                CommandOverrides.executeCommandOverrides(server, CommandEnvironment.SERVER, CommandEnvironment.DEDICATED_SERVER, UnaryOperator.identity());
            }
        });
        ServerEntityLevelEvents.LOAD.register((entity, level) -> {
            ServerPlayer serverPlayer;
            if (entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).getTags().contains(KEY_PLAYER_SEEN_WORLD)) {
                serverPlayer.addTag(KEY_PLAYER_SEEN_WORLD);
                String playerName = serverPlayer.getGameProfile().getName();
                CommandOverrides.executeCommandOverrides(serverPlayer.server, CommandEnvironment.PLAYER, CommandEnvironment.DEDICATED_PLAYER, s -> s.replaceAll("@[sp]", playerName));
            }
            return EventResult.PASS;
        });
    }

    private static void executeCommandOverrides(MinecraftServer server, CommandEnvironment commandEnvironment, CommandEnvironment dedicatedCommandEnvironment, UnaryOperator<String> formatter) {
        for (String command : (Collection)COMMAND_OVERRIDES.getOrDefault((Object)commandEnvironment, Collections.emptySet())) {
            server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), (String)formatter.apply(command));
        }
        if (server instanceof DedicatedServer) {
            for (String command : (Collection)COMMAND_OVERRIDES.getOrDefault((Object)dedicatedCommandEnvironment, Collections.emptySet())) {
                server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), (String)formatter.apply(command));
            }
        }
    }

    private static enum CommandEnvironment {
        DEDICATED_SERVER,
        SERVER,
        DEDICATED_PLAYER,
        PLAYER;

    }
}

