/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelReader;

public final class LookupHelper {
    private LookupHelper() {
    }

    public static <T> Optional<Registry<T>> getRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        return BuiltInRegistries.REGISTRY.getOptional(registryKey);
    }

    public static <T> Holder<T> lookup(Entity entity, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> resourceKey) {
        return LookupHelper.lookup((HolderLookup.Provider)entity.registryAccess(), registryKey, resourceKey);
    }

    public static <T> Holder<T> lookup(LevelReader levelReader, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> resourceKey) {
        return LookupHelper.lookup((HolderLookup.Provider)levelReader.registryAccess(), registryKey, resourceKey);
    }

    public static <T> Holder<T> lookup(HolderLookup.Provider registries, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> resourceKey) {
        return registries.lookupOrThrow(registryKey).getOrThrow(resourceKey);
    }

    public static Holder<Enchantment> lookupEnchantment(Entity entity, ResourceKey<Enchantment> resourceKey) {
        return LookupHelper.lookup((HolderLookup.Provider)entity.registryAccess(), Registries.ENCHANTMENT, resourceKey);
    }

    public static Holder<Enchantment> lookupEnchantment(LevelReader levelReader, ResourceKey<Enchantment> resourceKey) {
        return LookupHelper.lookup((HolderLookup.Provider)levelReader.registryAccess(), Registries.ENCHANTMENT, resourceKey);
    }

    public static Holder<Enchantment> lookupEnchantment(HolderLookup.Provider registries, ResourceKey<Enchantment> resourceKey) {
        return registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(resourceKey);
    }

    public static Holder<DamageType> lookupDamageType(Entity entity, ResourceKey<DamageType> resourceKey) {
        return LookupHelper.lookup((HolderLookup.Provider)entity.registryAccess(), Registries.DAMAGE_TYPE, resourceKey);
    }

    public static Holder<DamageType> lookupDamageType(LevelReader levelReader, ResourceKey<DamageType> resourceKey) {
        return LookupHelper.lookup((HolderLookup.Provider)levelReader.registryAccess(), Registries.DAMAGE_TYPE, resourceKey);
    }

    public static Holder<DamageType> lookupDamageType(HolderLookup.Provider registries, ResourceKey<DamageType> resourceKey) {
        return registries.lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(resourceKey);
    }
}

