/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public final class RegistryHelper {
    private RegistryHelper() {
    }

    public static <T> Registry<T> findBuiltInRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        Registry<T> registry = RegistryHelper.findNullableBuiltInRegistry(registryKey);
        Objects.requireNonNull(registry, () -> "registry for %s is null".formatted(registryKey));
        return registry;
    }

    @Nullable
    public static <T> Registry<T> findNullableBuiltInRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        return (Registry)BuiltInRegistries.REGISTRY.getValue(registryKey);
    }

    public static <T> Registry<T> findGameRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        Registry<T> registry = RegistryHelper.findNullableGameRegistry(registryKey);
        Objects.requireNonNull(registry, () -> "registry for %s is null".formatted(registryKey));
        return registry;
    }

    public static <T> Registry<T> findNullableGameRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        Optional<Registry<T>> registry = Optional.empty();
        MinecraftServer minecraftServer = CommonAbstractions.INSTANCE.getMinecraftServer();
        if (minecraftServer != null) {
            registry = minecraftServer.registryAccess().lookup(registryKey);
        }
        if (registry.isEmpty()) {
            registry = Optional.ofNullable(RegistryHelper.findNullableBuiltInRegistry(registryKey));
        }
        return registry.orElse(null);
    }

    public static <T> Optional<ResourceKey<T>> getResourceKey(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.getHolderReference(registryKey, object).map(Holder.Reference::key);
    }

    public static <T> Optional<ResourceKey<T>> getResourceKey(Registry<T> registry, T object) {
        return RegistryHelper.getHolderReference(registry, object).map(Holder.Reference::key);
    }

    public static <T> ResourceKey<T> getResourceKeyOrThrow(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.getResourceKey(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> ResourceKey<T> getResourceKeyOrThrow(Registry<T> registry, T object) {
        return RegistryHelper.getResourceKey(registry, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registry.key()) + ": " + String.valueOf(object)));
    }

    public static <T> Optional<Holder.Reference<T>> getHolderReference(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return Optional.ofNullable(RegistryHelper.getBuiltInRegistryHolder(object)).or(() -> {
            Registry registry = RegistryHelper.findGameRegistry(registryKey);
            return registry.getResourceKey(object).flatMap(arg_0 -> registry.get(arg_0));
        });
    }

    public static <T> Optional<Holder.Reference<T>> getHolderReference(Registry<T> registry, T object) {
        return Optional.ofNullable(RegistryHelper.getBuiltInRegistryHolder(object)).or(() -> registry.getResourceKey(object).flatMap(arg_0 -> ((Registry)registry).get(arg_0)));
    }

    public static <T> Holder.Reference<T> getHolderOrThrow(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.getHolderReference(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> Holder.Reference<T> getHolderOrThrow(Registry<T> registry, T object) {
        return RegistryHelper.getHolderReference(registry, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registry.key()) + ": " + String.valueOf(object)));
    }

    public static <T> Holder<T> wrapAsHolder(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.findGameRegistry(registryKey).wrapAsHolder(object);
    }

    public static <T> boolean is(TagKey<T> tagKey, T object) {
        Holder.Reference<T> holder = RegistryHelper.getBuiltInRegistryHolder(object);
        if (holder != null) {
            return holder.is(tagKey);
        }
        Registry<T> registry = RegistryHelper.findGameRegistry(tagKey.registry());
        return tagKey.isFor(registry.key()) && registry.wrapAsHolder(object).is(tagKey);
    }

    @Nullable
    public static <T> Holder.Reference<T> getBuiltInRegistryHolder(T object) {
        T t = object;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Block.class, Item.class, EntityType.class, Fluid.class, BlockEntityType.class}, t2, n)) {
            case 0 -> {
                Block block = (Block)t2;
                yield block.builtInRegistryHolder();
            }
            case 1 -> {
                Item item = (Item)t2;
                yield item.builtInRegistryHolder();
            }
            case 2 -> {
                EntityType entityType = (EntityType)t2;
                yield entityType.builtInRegistryHolder();
            }
            case 3 -> {
                Fluid fluid = (Fluid)t2;
                yield fluid.builtInRegistryHolder();
            }
            case 4 -> {
                BlockEntityType blockEntityType = (BlockEntityType)t2;
                yield blockEntityType.builtInRegistryHolder();
            }
            default -> null;
        };
    }
}

