/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;

public class ModEnchantCommand {
    public static final String KEY_REMOVE_SUCCESS_SINGLE = "commands.enchant.remove.success.single";
    public static final String KEY_REMOVE_SUCCESS_MULTIPLE = "commands.enchant.remove.success.multiple";
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.enchant.failed.entity", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.enchant.failed.itemless", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.enchant.failed.incompatible", (Object[])new Object[]{object}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.enchant.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enchant").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENCHANTMENT)).executes(commandContext -> ModEnchantCommand.enchant((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), (Holder<Enchantment>)ResourceArgument.getEnchantment((CommandContext)commandContext, (String)"enchantment")))).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(commandContext -> ModEnchantCommand.enchant((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), (Holder<Enchantment>)ResourceArgument.getEnchantment((CommandContext)commandContext, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level")))))));
    }

    private static int enchant(CommandSourceStack commandSourceStack, Collection<? extends Entity> collection, Holder<Enchantment> holder) throws CommandSyntaxException {
        return ModEnchantCommand.enchant(commandSourceStack, collection, holder, ((Enchantment)holder.value()).getMaxLevel());
    }

    private static int enchant(CommandSourceStack commandSourceStack, Collection<? extends Entity> entities, Holder<Enchantment> enchantment, int level) throws CommandSyntaxException {
        if (level > 255) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().create((Object)level, (Object)255);
        }
        int successCount = 0;
        for (Entity entity : entities) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ItemStack itemStack = livingEntity.getMainHandItem();
                if (!itemStack.isEmpty()) {
                    ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
                    if (level == 0 || (ModEnchantCommand.isBook(itemStack) || ((Enchantment)enchantment.value()).canEnchant(itemStack)) && ModEnchantCommand.isEnchantmentCompatible(itemEnchantments, enchantment)) {
                        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
                        if (mutable.getLevel(enchantment) != level) {
                            mutable.set(enchantment, level);
                        } else if (entities.size() == 1) {
                            throw ERROR_NOTHING_HAPPENED.create();
                        }
                        if (itemStack.is(Items.BOOK) && !mutable.keySet().isEmpty()) {
                            itemStack = itemStack.transmuteCopy((ItemLike)Items.ENCHANTED_BOOK, 1);
                        }
                        EnchantmentHelper.setEnchantments((ItemStack)itemStack, (ItemEnchantments)mutable.toImmutable());
                        if (itemStack.is(Items.ENCHANTED_BOOK) && mutable.keySet().isEmpty()) {
                            itemStack = itemStack.transmuteCopy((ItemLike)Items.BOOK, 1);
                        }
                        livingEntity.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
                        ++successCount;
                        continue;
                    }
                    if (entities.size() != 1) continue;
                    throw ERROR_INCOMPATIBLE.create((Object)itemStack.getItem().getName(itemStack).getString());
                }
                if (entities.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingEntity.getName().getString());
            }
            if (entities.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.getName().getString());
        }
        if (successCount == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (entities.size() == 1) {
            commandSourceStack.sendSuccess(() -> level > 0 ? Component.translatable((String)"commands.enchant.success.single", (Object[])new Object[]{Enchantment.getFullname((Holder)enchantment, (int)level), ((Entity)entities.iterator().next()).getDisplayName()}) : Component.translatableWithFallback((String)KEY_REMOVE_SUCCESS_SINGLE, (String)"Removed enchantment %s from %s's item", (Object[])new Object[]{ModEnchantCommand.getFullname(enchantment), ((Entity)entities.iterator().next()).getDisplayName()}), true);
        } else {
            commandSourceStack.sendSuccess(() -> level > 0 ? Component.translatable((String)"commands.enchant.success.multiple", (Object[])new Object[]{Enchantment.getFullname((Holder)enchantment, (int)level), entities.size()}) : Component.translatableWithFallback((String)KEY_REMOVE_SUCCESS_MULTIPLE, (String)"Removed enchantment %s from %s entities", (Object[])new Object[]{ModEnchantCommand.getFullname(enchantment), entities.size()}), true);
        }
        return successCount;
    }

    private static Component getFullname(Holder<Enchantment> enchantment) {
        MutableComponent mutableComponent = ((Enchantment)enchantment.value()).description().copy();
        if (enchantment.is(EnchantmentTags.CURSE)) {
            return mutableComponent.withStyle(ChatFormatting.RED);
        }
        return mutableComponent.withStyle(ChatFormatting.GRAY);
    }

    private static boolean isBook(ItemStack itemStack) {
        return itemStack.is(Items.BOOK) || itemStack.is(Items.ENCHANTED_BOOK);
    }

    private static boolean isEnchantmentCompatible(ItemEnchantments itemEnchantments, Holder<Enchantment> enchantment) {
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        mutable.set(enchantment, 0);
        return EnchantmentHelper.isEnchantmentCompatible((Collection)mutable.keySet(), enchantment);
    }
}

