/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.data.v2.core;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class NeoForgeDataProviderContext
extends DataProviderContext {
    private final ResourceManager clientResourceManager;
    private final ResourceManager serverResourceManager;

    public NeoForgeDataProviderContext(String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, ResourceManager clientResourceManager, ResourceManager serverResourceManager) {
        super(modId, packOutput, registries);
        this.clientResourceManager = clientResourceManager;
        this.serverResourceManager = serverResourceManager;
    }

    public static NeoForgeDataProviderContext fromEvent(GatherDataEvent evt, CompletableFuture<HolderLookup.Provider> registries) {
        return new NeoForgeDataProviderContext(evt.getModContainer().getModId(), evt.getGenerator().getPackOutput(), registries, evt.getResourceManager(PackType.CLIENT_RESOURCES), evt.getResourceManager(PackType.SERVER_DATA));
    }

    @Override
    public NeoForgeDataProviderContext withRegistries(CompletableFuture<HolderLookup.Provider> registries) {
        return new NeoForgeDataProviderContext(this.getModId(), this.getPackOutput(), registries, this.clientResourceManager, this.serverResourceManager);
    }

    public ResourceManager getClientResourceManager() {
        return this.clientResourceManager;
    }

    public ResourceManager getServerResourceManager() {
        return this.serverResourceManager;
    }

    @FunctionalInterface
    public static interface Factory
    extends Function<NeoForgeDataProviderContext, DataProvider> {
    }
}

