/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.client.renderer.v1.RenderPropertyKey;
import fuzs.puzzleslib.impl.client.core.ClientFactories;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.client.core.NeoForgeClientModConstructor;
import fuzs.puzzleslib.neoforge.impl.client.key.NeoForgeKeyMappingHelper;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.context.ContextKey;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeClientFactories
implements ClientFactories {
    private final Map<RenderPropertyKey<?>, ContextKey<?>> entityRenderStateKeys = new IdentityHashMap();

    @Override
    public void constructClientMod(String modId, ClientModConstructor modConstructor) {
        NeoForgeClientModConstructor.construct(modConstructor, modId);
    }

    @Override
    public KeyMappingHelper getKeyMappingActivationHelper() {
        return new NeoForgeKeyMappingHelper();
    }

    @Override
    @Nullable
    public <T> T getRenderProperty(EntityRenderState entityRenderState, RenderPropertyKey<T> key) {
        return (T)entityRenderState.getRenderData(this.getContextKey(key));
    }

    @Override
    public <T> void setRenderProperty(EntityRenderState entityRenderState, RenderPropertyKey<T> key, @Nullable T t) {
        entityRenderState.setRenderData(this.getContextKey(key), t);
    }

    private <T> ContextKey<T> getContextKey(RenderPropertyKey<T> key) {
        return this.entityRenderStateKeys.computeIfAbsent(key, keyX -> new ContextKey(keyX.resourceLocation()));
    }

    @Override
    public void registerBuiltinResourcePack(ResourceLocation resourceLocation, Component displayName, boolean required) {
        NeoForgeModContainerHelper.getOptionalModEventBus(resourceLocation.getNamespace()).ifPresent(eventBus -> eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.CLIENT_RESOURCES) {
                evt.addPackFinders(resourceLocation.withPrefix("resourcepacks/"), PackType.CLIENT_RESOURCES, displayName, PackSource.BUILT_IN, required, Pack.Position.TOP);
            }
        }));
    }
}

