/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.core.context.BiomeModificationsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.BlockInteractionsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.CompostableBlocksContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.DataPackRegistriesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.DataPackSourcesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.EntityAttributesCreateContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.EntityAttributesModifyContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.FlammableBlocksContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.FuelValuesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.GameRegistriesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.GameplayContentContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.SpawnPlacementsContextNeoForgeImpl;
import net.minecraft.server.packs.PackType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

public final class NeoForgeModConstructor {
    private NeoForgeModConstructor() {
    }

    public static void construct(ModConstructor constructor, String modId) {
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> {
            constructor.onConstructMod();
            constructor.onRegisterGameplayContent(new GameplayContentContextNeoForgeImpl(modId));
            constructor.onRegisterCompostableBlocks(new CompostableBlocksContextNeoForgeImpl(modId));
            constructor.onRegisterFuelValues(new FuelValuesContextNeoForgeImpl(modId));
            constructor.onRegisterBiomeModifications(new BiomeModificationsContextNeoForgeImpl(modId, (IEventBus)eventBus));
            eventBus.addListener(evt -> evt.enqueueWork(() -> {
                constructor.onCommonSetup();
                constructor.onRegisterFlammableBlocks(new FlammableBlocksContextNeoForgeImpl());
                constructor.onRegisterBlockInteractions(new BlockInteractionsContextNeoForgeImpl());
            }));
            eventBus.addListener(evt -> constructor.onRegisterSpawnPlacements(new SpawnPlacementsContextNeoForgeImpl((RegisterSpawnPlacementsEvent)evt)));
            eventBus.addListener(evt -> constructor.onEntityAttributeCreation(new EntityAttributesCreateContextNeoForgeImpl((arg_0, arg_1) -> ((EntityAttributeCreationEvent)evt).put(arg_0, arg_1))));
            eventBus.addListener(evt -> constructor.onEntityAttributeModification(new EntityAttributesModifyContextNeoForgeImpl((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2))));
            eventBus.addListener(evt -> {
                if (evt.getPackType() == PackType.SERVER_DATA) {
                    constructor.onAddDataPackFinders(new DataPackSourcesContextNeoForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
                }
            });
            eventBus.addListener(evt -> constructor.onGameRegistriesContext(new GameRegistriesContextNeoForgeImpl((NewRegistryEvent)evt)));
            eventBus.addListener(evt -> constructor.onDataPackRegistriesContext(new DataPackRegistriesContextNeoForgeImpl((DataPackRegistryEvent.NewRegistry)evt)));
        });
    }
}

