/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core.context;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.neoforge.api.data.v2.core.DataProviderHelper;
import fuzs.puzzleslib.neoforge.impl.biome.BiomeLoadingContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.ClimateSettingsContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.GenerationSettingsContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.MobSpawnSettingsContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.SpecialEffectsContextNeoForge;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.data.JsonCodecProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public record BiomeModificationsContextNeoForgeImpl(String modId, IEventBus eventBus, Multimap<BiomeLoadingPhase, Map.Entry<Predicate<BiomeLoadingContext>, Consumer<BiomeModificationContext>>> biomeModifications) implements BiomeModificationsContext
{
    public BiomeModificationsContextNeoForgeImpl(String modId, IEventBus eventBus) {
        this(modId, eventBus, (Multimap<BiomeLoadingPhase, Map.Entry<Predicate<BiomeLoadingContext>, Consumer<BiomeModificationContext>>>)HashMultimap.create());
    }

    @Override
    public void registerBiomeModification(BiomeLoadingPhase biomeLoadingPhase, Predicate<BiomeLoadingContext> biomeSelector, Consumer<BiomeModificationContext> biomeModifier) {
        Objects.requireNonNull(biomeLoadingPhase, "biome loading phase is null");
        Objects.requireNonNull(biomeSelector, "biome selector is null");
        Objects.requireNonNull(biomeModifier, "biome modifier is null");
        if (this.biomeModifications.isEmpty()) {
            BiomeModifierImpl biomeModifierImpl = new BiomeModifierImpl();
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)this.modId);
            deferredRegister.register(this.eventBus);
            DeferredHolder holder = deferredRegister.register("biome_modifications", () -> ((BiomeModifier)biomeModifierImpl).codec());
            DataProviderHelper.registerDataProviders(this.modId, arg_0 -> this.lambda$registerBiomeModification$0((Holder)holder, biomeModifierImpl, arg_0));
        }
        this.biomeModifications.put((Object)biomeLoadingPhase, Map.entry(biomeSelector, biomeModifier));
    }

    private /* synthetic */ DataProvider lambda$registerBiomeModification$0(final Holder holder, final BiomeModifier biomeModifierImpl, DataProviderContext context) {
        return new JsonCodecProvider<BiomeModifier>(this, context.getPackOutput(), PackOutput.Target.DATA_PACK, NeoForgeRegistries.Keys.BIOME_MODIFIERS.location().toString().replace(':', '/'), BiomeModifier.DIRECT_CODEC, context.getRegistries(), context.getModId()){

            protected void gather() {
                this.unconditional(holder.getKey().location(), biomeModifierImpl);
            }
        };
    }

    private class BiomeModifierImpl
    implements BiomeModifier {
        private static final Map<BiomeModifier.Phase, BiomeLoadingPhase> BIOME_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)BiomeModifier.Phase.ADD, (Object)((Object)BiomeLoadingPhase.ADDITIONS), (Object)BiomeModifier.Phase.REMOVE, (Object)((Object)BiomeLoadingPhase.REMOVALS), (Object)BiomeModifier.Phase.MODIFY, (Object)((Object)BiomeLoadingPhase.MODIFICATIONS), (Object)BiomeModifier.Phase.AFTER_EVERYTHING, (Object)((Object)BiomeLoadingPhase.POST_PROCESSING)));
        private final MapCodec<? extends BiomeModifier> codec = MapCodec.unit((Object)this);

        private BiomeModifierImpl() {
        }

        public void modify(Holder<Biome> holder, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            Collection biomeModification;
            BiomeLoadingPhase biomeLoadingPhase = BIOME_PHASE_CONVERSIONS.get(phase);
            if (biomeLoadingPhase != null && !(biomeModification = BiomeModificationsContextNeoForgeImpl.this.biomeModifications.get((Object)biomeLoadingPhase)).isEmpty()) {
                MinecraftServer minecraftServer = CommonAbstractions.INSTANCE.getMinecraftServer();
                Objects.requireNonNull(minecraftServer, "minecraft server is null");
                RegistryAccess.Frozen registryAccess = minecraftServer.registryAccess();
                BiomeLoadingContextNeoForge biomeLoadingContext = new BiomeLoadingContextNeoForge((RegistryAccess)registryAccess, holder);
                BiomeModificationContext biomeModificationContext = BiomeModifierImpl.createModificationContext((RegistryAccess)registryAccess, builder);
                for (Map.Entry entry : biomeModification) {
                    if (!((Predicate)entry.getKey()).test(biomeLoadingContext)) continue;
                    ((Consumer)entry.getValue()).accept(biomeModificationContext);
                }
            }
        }

        static BiomeModificationContext createModificationContext(RegistryAccess registryAccess, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            ClimateSettingsContextNeoForge climateSettings = new ClimateSettingsContextNeoForge(builder.getClimateSettings());
            SpecialEffectsContextNeoForge specialEffects = new SpecialEffectsContextNeoForge(builder.getSpecialEffects());
            GenerationSettingsContextNeoForge generationSettings = new GenerationSettingsContextNeoForge(registryAccess, builder.getGenerationSettings());
            MobSpawnSettingsContextNeoForge mobSpawnSettings = new MobSpawnSettingsContextNeoForge(builder.getMobSpawnSettings());
            return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return this.codec;
        }
    }
}

