/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core.context;

import fuzs.puzzleslib.impl.core.context.FuelValuesContextImpl;
import fuzs.puzzleslib.neoforge.api.data.v2.core.DataProviderHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;

public final class FuelValuesContextNeoForgeImpl
extends FuelValuesContextImpl {
    private final String modId;

    public FuelValuesContextNeoForgeImpl(String modId) {
        this.modId = modId;
    }

    @Override
    protected void registerListenerIfNecessary() {
        if (this.items.isEmpty() && this.itemTags.isEmpty()) {
            DataProviderHelper.registerDataProviders(this.modId, context -> new DataMapProvider(context.getPackOutput(), context.getRegistries()){

                protected void gather(HolderLookup.Provider registries) {
                    DataMapProvider.Builder builder = this.builder(NeoForgeDataMaps.FURNACE_FUELS);
                    for (Object2IntMap.Entry entry : FuelValuesContextNeoForgeImpl.this.items.object2IntEntrySet()) {
                        Holder.Reference holder = ((ItemLike)((Holder)entry.getKey()).value()).asItem().builtInRegistryHolder();
                        builder.add((Holder)holder, (Object)new FurnaceFuel(entry.getIntValue()), false, new ICondition[0]);
                    }
                    for (Object2IntMap.Entry entry : FuelValuesContextNeoForgeImpl.this.itemTags.object2IntEntrySet()) {
                        builder.add((TagKey)entry.getKey(), (Object)new FurnaceFuel(entry.getIntValue()), false, new ICondition[0]);
                    }
                }

                public String getName() {
                    DataMapType dataMapType = NeoForgeDataMaps.FURNACE_FUELS;
                    return super.getName() + " for " + String.valueOf(ResourceKey.create((ResourceKey)dataMapType.registryKey(), (ResourceLocation)dataMapType.id()));
                }
            });
        }
    }
}

