/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.content.CommandOverrides;
import fuzs.puzzleslib.impl.content.GameRuleValueOverrides;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.GameRules;
import org.objectweb.asm.Type;

public class PuzzlesLibDevelopment
extends PuzzlesLib
implements ModConstructor {
    @Override
    public void onConstructMod() {
        CommandOverrides.registerEventHandlers();
    }

    @Override
    public void onCommonSetup() {
        PuzzlesLibDevelopment.initializeGameRules();
        PuzzlesLibDevelopment.initializeCommands();
    }

    private static void initializeCommands() {
        CommandOverrides.registerServerCommand("time set 4000", false);
        CommandOverrides.registerPlayerCommand("op @s", true);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.NIGHT_VISION);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.RESISTANCE);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.STRENGTH);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.WATER_BREATHING);
    }

    private static void initializeGameRules() {
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DAYLIGHT, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_WEATHER_CYCLE, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_KEEPINVENTORY, true);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DOFIRETICK, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_MOBGRIEFING, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DOINSOMNIA, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DO_PATROL_SPAWNING, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DO_TRADER_SPAWNING, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DO_VINES_SPREAD, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.IntegerValue>)GameRules.RULE_MAX_ENTITY_CRAMMING, 0);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.IntegerValue>)GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY, 1);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_COMMANDBLOCKOUTPUT, false);
    }

    public static void printClazzComponentsWithoutAccess(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || field.isSynthetic()) continue;
            LOGGER.info("transitive-accessible\tfield\t{}\t{}\t{}", new Object[]{Type.getInternalName(field.getDeclaringClass()), field.getName(), Type.getDescriptor(field.getType())});
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (Modifier.isPublic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).isSynthetic()) continue;
            LOGGER.info("transitive-accessible\tmethod\t{}\t{}\t{}", new Object[]{Type.getInternalName(((Method)accessibleObject).getDeclaringClass()), ((Method)accessibleObject).getName(), Type.getMethodDescriptor((Method)accessibleObject)});
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath("puzzleslib", path);
    }
}

