/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.mixin.client;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
abstract class EditBoxMixin
extends AbstractWidget {
    @Shadow
    private String value;
    @Shadow
    private int cursorPos;
    @Shadow
    private int highlightPos;
    @Unique
    private long lastClickTime;
    @Unique
    private boolean doubleClick;
    @Unique
    private int doubleClickHighlightPos;
    @Unique
    private int doubleClickCursorPos;

    public EditBoxMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Inject(method={"deleteText(IZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void deleteText(int charCount, boolean hasControlDown, CallbackInfo callback) {
        if (hasControlDown) {
            if (charCount < 0) {
                this.deleteChars(-this.cursorPos);
            }
        } else if (Minecraft.getInstance().hasAltDown()) {
            this.deleteWords(charCount);
        } else {
            this.deleteChars(charCount);
        }
        callback.cancel();
    }

    @Shadow
    public abstract void deleteWords(int var1);

    @Shadow
    public abstract void deleteChars(int var1);

    @Shadow
    public abstract int getWordPosition(int var1);

    @Shadow
    protected abstract int getWordPosition(int var1, int var2, boolean var3);

    @Inject(method={"getWordPosition(IIZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getWordPosition(int numWords, int pos, boolean skipConsecutiveSpaces, CallbackInfoReturnable<Integer> callback) {
        int i = pos;
        boolean backwards = numWords < 0;
        int skippedWords = Math.abs(numWords);
        for (int k = 0; k < skippedWords; ++k) {
            if (!backwards) {
                int l = this.value.length();
                while (skipConsecutiveSpaces && i == pos && i < l && !EditBoxMixin.isWordChar(this.value.charAt(i))) {
                    ++i;
                    ++pos;
                }
                while (i < l && EditBoxMixin.isWordChar(this.value.charAt(i))) {
                    ++i;
                }
                continue;
            }
            while (skipConsecutiveSpaces && i == pos && i > 0 && !EditBoxMixin.isWordChar(this.value.charAt(i - 1))) {
                --i;
                --pos;
            }
            while (i > 0 && EditBoxMixin.isWordChar(this.value.charAt(i - 1))) {
                --i;
            }
        }
        callback.setReturnValue((Object)i);
    }

    @Unique
    private static boolean isWordChar(char charAt) {
        return charAt == '_' || Character.isAlphabetic(charAt) || Character.isDigit(charAt);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> callback) {
        if (this.isActive() && this.isFocused()) {
            if (keyEvent.isRight()) {
                boolean allowedToMoveRight = true;
                if (!keyEvent.hasShiftDown() && this.highlightPos != this.cursorPos) {
                    this.setCursorPosition(Math.max(this.getCursorPosition(), this.highlightPos));
                    this.setHighlightPos(this.getCursorPosition());
                    allowedToMoveRight = false;
                }
                if (keyEvent.hasControlDown()) {
                    this.moveCursorToEnd(keyEvent.hasShiftDown());
                } else if (keyEvent.hasAltDown()) {
                    this.moveCursorTo(this.getWordPosition(1), keyEvent.hasShiftDown());
                } else if (allowedToMoveRight) {
                    this.moveCursor(1, keyEvent.hasShiftDown());
                }
                callback.setReturnValue((Object)true);
            } else if (keyEvent.isLeft()) {
                boolean allowedToMoveLeft = true;
                if (!keyEvent.hasShiftDown() && this.highlightPos != this.cursorPos) {
                    this.setCursorPosition(Math.min(this.getCursorPosition(), this.highlightPos));
                    this.setHighlightPos(this.getCursorPosition());
                    allowedToMoveLeft = false;
                }
                if (keyEvent.hasControlDown()) {
                    this.moveCursorToStart(keyEvent.hasShiftDown());
                } else if (keyEvent.hasAltDown()) {
                    this.moveCursorTo(this.getWordPosition(-1), keyEvent.hasShiftDown());
                } else if (allowedToMoveLeft) {
                    this.moveCursor(-1, keyEvent.hasShiftDown());
                }
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Shadow
    public abstract void moveCursor(int var1, boolean var2);

    @Shadow
    public abstract void moveCursorTo(int var1, boolean var2);

    @Shadow
    public abstract void setCursorPosition(int var1);

    @Shadow
    public abstract void moveCursorToStart(boolean var1);

    @Shadow
    public abstract void moveCursorToEnd(boolean var1);

    @Shadow
    public abstract int getCursorPosition();

    @Shadow
    public abstract void setHighlightPos(int var1);

    @Inject(method={"onClick"}, at={@At(value="TAIL")})
    public void onClick(MouseButtonEvent mouseButtonEvent, boolean doubleClick, CallbackInfo callback) {
        long millis = Util.getMillis();
        boolean tripleClick = this.doubleClick;
        boolean bl = this.doubleClick = millis - this.lastClickTime < 250L;
        if (this.doubleClick) {
            if (tripleClick) {
                this.moveCursorToEnd(false);
                this.setHighlightPos(0);
            } else {
                this.doubleClickHighlightPos = this.getWordPosition(1, this.getCursorPosition(), false);
                this.doubleClickCursorPos = this.getWordPosition(-1, this.getCursorPosition(), false);
            }
        }
        this.lastClickTime = millis;
    }

    @Shadow
    private int findClickedPositionInText(MouseButtonEvent mouseButtonEvent) {
        throw new RuntimeException();
    }

    @Inject(method={"onDrag"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onDrag(MouseButtonEvent mouseButtonEvent, double dragX, double dragY, CallbackInfo callback) {
        if (this.doubleClick) {
            int clickedPosition = this.findClickedPositionInText(mouseButtonEvent);
            if (this.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y())) {
                int rightBoundary = this.getWordPosition(1, clickedPosition, false);
                this.moveCursorTo(Math.max(this.doubleClickHighlightPos, rightBoundary), false);
                int leftBoundary = this.getWordPosition(-1, clickedPosition, false);
                this.moveCursorTo(Math.min(this.doubleClickCursorPos, leftBoundary), true);
            } else {
                if (clickedPosition > this.doubleClickHighlightPos) {
                    this.moveCursorToEnd(false);
                } else {
                    this.moveCursorTo(this.doubleClickHighlightPos, false);
                }
                if (clickedPosition < this.doubleClickCursorPos) {
                    this.moveCursorToStart(true);
                } else {
                    this.moveCursorTo(this.doubleClickCursorPos, true);
                }
            }
            callback.cancel();
        } else if (!this.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y())) {
            if (this.highlightPos < this.findClickedPositionInText(mouseButtonEvent)) {
                this.moveCursorToEnd(true);
            } else {
                this.moveCursorToStart(true);
            }
            callback.cancel();
        }
    }
}

