/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.data.v2.core;

import com.google.common.base.Function;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.data.v2.ModPackMetadataProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.core.RegistriesDataProvider;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.api.data.v2.core.NeoForgeDataProviderContext;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.commons.lang3.ArrayUtils;

public final class DataProviderHelper {
    private DataProviderHelper() {
    }

    public static void registerDataProviders(String modId, NeoForgeDataProviderContext.Factory ... dataProviderFactories) {
        DataProviderHelper.registerDataProviders(modId, new RegistrySetBuilder(), dataProviderFactories);
    }

    public static void registerDataProviders(ResourceLocation resourceLocation, PackType packType, NeoForgeDataProviderContext.Factory ... dataProviderFactories) {
        DataProviderHelper.registerDataProviders(resourceLocation, packType, new RegistrySetBuilder(), dataProviderFactories);
    }

    public static void registerDataProviders(String modId, RegistrySetBuilder registrySetBuilder, NeoForgeDataProviderContext.Factory ... dataProviderFactories) {
        DataProviderHelper.registerDataProviders(modId, registrySetBuilder, dataProviderFactories, factory -> (event, packOutput, lookupProvider) -> (DataProvider)factory.apply(NeoForgeDataProviderContext.fromEvent(event, packOutput, lookupProvider)));
    }

    public static void registerDataProviders(ResourceLocation resourceLocation, PackType packType, RegistrySetBuilder registrySetBuilder, NeoForgeDataProviderContext.Factory ... dataProviderFactories) {
        DataProviderHelper.registerDataProviders(resourceLocation, packType, registrySetBuilder, (NeoForgeDataProviderContext.Factory[])ArrayUtils.add((Object[])dataProviderFactories, context -> new ModPackMetadataProvider(packType, (DataProviderContext)context)), factory -> (event, packOutput, lookupProvider) -> (DataProvider)factory.apply(NeoForgeDataProviderContext.fromEvent(event, packOutput, lookupProvider)));
    }

    private static <T> void registerDataProviders(String modId, RegistrySetBuilder registrySetBuilder, T[] dataProviderFactories, Function<T, Factory> factoryConverter) {
        if (!ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> eventBus.addListener(event -> DataProviderHelper.addDataProviders((GatherDataEvent)event, registrySetBuilder, dataProviderFactories, factoryConverter, event.getGenerator().getPackOutput(), arg_0 -> ((GatherDataEvent.Client)event).addProvider(arg_0))));
    }

    private static <T> void registerDataProviders(ResourceLocation resourceLocation, PackType packType, RegistrySetBuilder registrySetBuilder, T[] dataProviderFactories, Function<T, Factory> factoryConverter) {
        if (!ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        NeoForgeModContainerHelper.getOptionalModEventBus(resourceLocation.getNamespace()).ifPresent(eventBus -> eventBus.addListener(event -> {
            Path path = event.getGenerator().getPackOutput().getOutputFolder();
            PackOutput packOutput = new PackOutput(event.getGenerator().getPackOutput().getOutputFolder().resolve(packType.getDirectory()).resolve(resourceLocation.getNamespace()).resolve(packType == PackType.CLIENT_RESOURCES ? "resourcepacks" : "datapacks").resolve(resourceLocation.getPath()));
            DataGenerator.PackGenerator packGenerator = event.getGenerator().getPackGenerator(true, resourceLocation.toString(), path.relativize(packOutput.getOutputFolder()).toString());
            DataProviderHelper.addDataProviders((GatherDataEvent)event, registrySetBuilder, dataProviderFactories, factoryConverter, packOutput, dataProvider -> packGenerator.addProvider(packOutputX -> dataProvider));
        }));
    }

    private static <T> void addDataProviders(GatherDataEvent event, RegistrySetBuilder registrySetBuilder, T[] dataProviderFactories, Function<T, Factory> factoryConverter, PackOutput packOutput, Consumer<DataProvider> dataProviderConsumer) {
        if (!registrySetBuilder.getEntryKeys().isEmpty()) {
            event.createDatapackRegistryObjects(registrySetBuilder);
        }
        CompletableFuture<HolderLookup.Provider> lookupProvider = event.getLookupProvider();
        for (T dataProviderFactory : dataProviderFactories) {
            DataProvider dataProvider = ((Factory)factoryConverter.apply(dataProviderFactory)).apply(event, packOutput, lookupProvider);
            if (dataProvider instanceof RegistriesDataProvider) {
                RegistriesDataProvider registriesDataProvider = (RegistriesDataProvider)dataProvider;
                lookupProvider = registriesDataProvider.getRegistries();
            }
            dataProviderConsumer.accept(dataProvider);
        }
    }

    @FunctionalInterface
    private static interface Factory {
        public DataProvider apply(GatherDataEvent var1, PackOutput var2, CompletableFuture<HolderLookup.Provider> var3);
    }
}

