/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.config;

import com.google.common.collect.ImmutableSet;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.Collection;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MultiConfigurationScreen
extends OptionsSubScreen {
    private static final String LANG_PREFIX = "neoforge.configuration.uitext.";
    private static final String SECTION = "neoforge.configuration.uitext.section";
    private static final String FILENAME_TOOLTIP = "neoforge.configuration.uitext.filenametooltip";
    protected final Collection<String> modIds;
    protected final ConfigurationScreen configurationScreen;

    public static BiFunction<net.neoforged.fml.ModContainer, Screen, Screen> getScreenFactory(String[] mergedModIds) {
        return (modContainer, lastScreen) -> {
            ConfigurationScreen configurationScreen = new ConfigurationScreen(modContainer, lastScreen, (configurationScreenX, type, modConfig, component) -> new ConfigurationScreen.ConfigurationSectionScreen((Screen)configurationScreenX, ModConfig.Type.COMMON, modConfig, component));
            return new MultiConfigurationScreen((Collection<String>)ImmutableSet.builder().add((Object)modContainer.getModId()).add((Object[])mergedModIds).build(), (Screen)lastScreen, configurationScreen);
        };
    }

    protected MultiConfigurationScreen(Collection<String> modIds, Screen lastScreen, ConfigurationScreen configurationScreen) {
        super(lastScreen, Minecraft.getInstance().options, configurationScreen.getTitle());
        this.modIds = modIds;
        this.configurationScreen = configurationScreen;
    }

    protected void init() {
        super.init();
        this.configurationScreen.init(this.minecraft, this.width, this.height);
    }

    protected void addOptions() {
        for (ModConfig.Type type : ModConfig.Type.values()) {
            boolean headerAdded = false;
            for (ModConfig modConfig : ModConfigs.getConfigSet((ModConfig.Type)type)) {
                if (!this.modIds.contains(modConfig.getModId())) continue;
                if (!headerAdded) {
                    this.list.addSmall((AbstractWidget)new StringWidget(310, 20, (Component)Component.translatable((String)(LANG_PREFIX + type.name().toLowerCase(Locale.ENGLISH))).withStyle(ChatFormatting.UNDERLINE), this.font), null);
                    headerAdded = true;
                }
                Button btn = Button.builder((Component)Component.translatable((String)SECTION, (Object[])new Object[]{this.translatableConfig(modConfig, "", "neoforge.configuration.uitext.type." + modConfig.getType().name().toLowerCase(Locale.ROOT))}), button -> {
                    Component component = this.translatableConfig(modConfig, ".title", "neoforge.configuration.uitext.title." + type.name().toLowerCase(Locale.ROOT));
                    this.minecraft.setScreen((Screen)new MultiConfigurationSectionScreen((Screen)this, type, modConfig, component, restartType -> {
                        this.configurationScreen.needsRestart = this.configurationScreen.needsRestart.with(restartType);
                    }));
                }).width(310).build();
                MutableComponent tooltip = Component.empty();
                if (!((ModConfigSpec)modConfig.getSpec()).isLoaded()) {
                    tooltip.append(ConfigurationScreen.TOOLTIP_CANNOT_EDIT_NOT_LOADED).append((Component)Component.literal((String)"\n\n"));
                    btn.active = false;
                } else if (type == ModConfig.Type.SERVER && this.minecraft.getCurrentServer() != null && !this.minecraft.isSingleplayer()) {
                    tooltip.append(ConfigurationScreen.TOOLTIP_CANNOT_EDIT_THIS_WHILE_ONLINE).append((Component)Component.literal((String)"\n\n"));
                    btn.active = false;
                } else if (type == ModConfig.Type.SERVER && this.minecraft.hasSingleplayerServer() && this.minecraft.getSingleplayerServer().isPublished()) {
                    tooltip.append(ConfigurationScreen.TOOLTIP_CANNOT_EDIT_THIS_WHILE_OPEN_TO_LAN).append((Component)Component.literal((String)"\n\n"));
                    btn.active = false;
                }
                tooltip.append((Component)Component.translatable((String)FILENAME_TOOLTIP, (Object[])new Object[]{modConfig.getFileName()}));
                btn.setTooltip(Tooltip.create((Component)tooltip));
                this.list.addSmall((AbstractWidget)btn, null);
            }
        }
    }

    public Component translatableConfig(ModConfig modConfig, String suffix, String fallback) {
        String fileName = modConfig.getFileName().replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase(Locale.ENGLISH);
        String translationKey = modConfig.getModId() + ".configuration.section." + fileName + suffix;
        String modName = ModLoaderEnvironment.INSTANCE.getModContainer(modConfig.getModId()).map(ModContainer::getDisplayName).orElse(modConfig.getModId());
        return Component.translatable((String)(I18n.exists((String)translationKey) ? translationKey : fallback), (Object[])new Object[]{modName});
    }

    public void onClose() {
        this.configurationScreen.onClose();
    }

    public static class MultiConfigurationSectionScreen
    extends ConfigurationScreen.ConfigurationSectionScreen {
        private final Consumer<ModConfigSpec.RestartType> needsRestartCallback;

        public MultiConfigurationSectionScreen(Screen parent, ModConfig.Type type, ModConfig modConfig, Component title, Consumer<ModConfigSpec.RestartType> needsRestartCallback) {
            super(parent, type, modConfig, title);
            this.needsRestartCallback = needsRestartCallback;
            this.needsRestart = ModConfigSpec.RestartType.NONE;
        }

        public void onClose() {
            if (this.changed) {
                this.needsRestartCallback.accept(this.needsRestart);
            }
            super.onClose();
        }
    }
}

