/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core.context;

import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationHandler;
import fuzs.puzzleslib.neoforge.impl.client.key.NeoForgeKeyMappingHelper;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;

public final class KeyMappingsContextNeoForgeImpl
implements KeyMappingsContext {
    private final RegisterKeyMappingsEvent event;
    private final Set<KeyMapping.Category> keyCategories = Sets.newIdentityHashSet();

    public KeyMappingsContextNeoForgeImpl(RegisterKeyMappingsEvent event) {
        this.event = event;
    }

    @Override
    public void registerKeyMapping(KeyMapping keyMapping, KeyActivationHandler activationHandler) {
        Objects.requireNonNull(keyMapping, "key mapping is null");
        Objects.requireNonNull(activationHandler, "activation handler is null");
        this.event.register(keyMapping);
        keyMapping.setKeyConflictContext((IKeyConflictContext)NeoForgeKeyMappingHelper.KEY_CONTEXTS.get((Object)activationHandler.getActivationContext()));
        this.registerKeyCategoryIfNecessary(keyMapping);
        this.registerKeyActivationHandles(keyMapping, activationHandler);
    }

    private void registerKeyCategoryIfNecessary(KeyMapping keyMapping) {
        Objects.requireNonNull(keyMapping.getCategory(), "key category is null");
        Objects.requireNonNull(keyMapping.getCategory().id(), "key category id is null");
        if (this.keyCategories.add(keyMapping.getCategory())) {
            this.event.registerCategory(keyMapping.getCategory());
        }
    }

    private void registerKeyActivationHandles(KeyMapping keyMapping, KeyActivationHandler activationHandler) {
        Consumer<? extends Screen> screenConsumer;
        Consumer<Minecraft> gameConsumer = activationHandler.gameHandler();
        if (gameConsumer != null) {
            NeoForge.EVENT_BUS.addListener(event -> {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    while (keyMapping.consumeClick()) {
                        gameConsumer.accept(minecraft);
                    }
                }
            });
        }
        if ((screenConsumer = activationHandler.screenHandler()) != null) {
            NeoForge.EVENT_BUS.addListener(event -> {
                if (activationHandler.screenType().isInstance(event.getScreen()) && keyMapping.matches(event.getKeyEvent())) {
                    screenConsumer.accept(event.getScreen());
                    event.setCanceled(true);
                }
            });
        }
    }
}

