/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v3.data;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.core.v1.utility.NbtSerializable;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.Objects;
import net.minecraft.class_2487;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class CapabilityComponent<T>
implements NbtSerializable {
    private boolean initialized;
    private CapabilityKey<T, CapabilityComponent<T>> capabilityKey;
    private T holder;

    protected final T getHolder() {
        Objects.requireNonNull(this.holder, "holder is null");
        return this.holder;
    }

    @ApiStatus.Internal
    public final void initialize(CapabilityKey<T, CapabilityComponent<T>> capabilityKey, T holder) {
        this.initialize(capabilityKey, holder, false);
    }

    @ApiStatus.Internal
    public final void initialize(CapabilityKey<T, CapabilityComponent<T>> capabilityKey, T holder, boolean forceOverride) {
        if (forceOverride || !this.initialized) {
            this.initialized = true;
            Objects.requireNonNull(capabilityKey, "capability key is null");
            this.capabilityKey = capabilityKey;
            Objects.requireNonNull(holder, "capability holder is null");
            this.holder = holder;
            this.initialize();
        }
    }

    protected void initialize() {
    }

    @MustBeInvokedByOverriders
    public void setChanged() {
        this.setChanged(null);
    }

    @MustBeInvokedByOverriders
    public void setChanged(@Nullable PlayerSet playerSet) {
        this.capabilityKey.setChanged(this, playerSet);
    }

    @Override
    public void write(class_2487 compoundTag) {
    }

    @Override
    public void read(class_2487 compoundTag) {
    }
}

