/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.BaseModConstructor;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.context.AddReloadListenersContext;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.BlockInteractionsContext;
import fuzs.puzzleslib.api.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesModifyContext;
import fuzs.puzzleslib.api.core.v1.context.FlammableBlocksContext;
import fuzs.puzzleslib.api.core.v1.context.FuelBurnTimesContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.core.CommonFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.apache.logging.log4j.util.Strings;

public interface ModConstructor
extends BaseModConstructor {
    public static void construct(String modId, Supplier<ModConstructor> modConstructor) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id is empty");
        }
        ModConstructor instance = modConstructor.get();
        class_2960 identifier = ModContext.getPairingIdentifier(modId, instance);
        PuzzlesLib.LOGGER.info("Constructing common components for {}", (Object)identifier);
        ModContext modContext = ModContext.get(modId);
        Set<ContentRegistrationFlags> availableFlags = Set.of(instance.getContentRegistrationFlags());
        Set<ContentRegistrationFlags> flagsToHandle = modContext.getFlagsToHandle(availableFlags);
        modContext.beforeModConstruction();
        CommonFactories.INSTANCE.constructMod(modId, instance, availableFlags, flagsToHandle);
        modContext.afterModConstruction(identifier);
    }

    public static class_2960 id(String modId, String path) {
        return new class_2960(modId, path);
    }

    default public void onConstructMod() {
    }

    default public void onCommonSetup() {
    }

    default public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
    }

    default public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
    }

    default public void onEntityAttributeModification(EntityAttributesModifyContext context) {
    }

    default public void onRegisterFuelBurnTimes(FuelBurnTimesContext context) {
    }

    default public void onRegisterBiomeModifications(BiomeModificationsContext context) {
    }

    default public void onRegisterFlammableBlocks(FlammableBlocksContext context) {
    }

    default public void onRegisterBlockInteractions(BlockInteractionsContext context) {
    }

    default public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
    }

    default public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
    }

    default public void onAddDataPackFinders(PackRepositorySourcesContext context) {
    }

    default public void onRegisterDataPackReloadListeners(AddReloadListenersContext context) {
    }
}

