/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_175;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_8779;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeProvider
extends class_2446 {
    protected final String modId;

    public AbstractRecipeProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractRecipeProvider(String modId, class_7784 packOutput) {
        super(packOutput);
        this.modId = modId;
    }

    @Nullable
    private static <T> JsonElement searchAndReplaceValue(@Nullable JsonElement jsonElement, T searchFor, T replaceWith) {
        block10: {
            block11: {
                Objects.requireNonNull(searchFor, "search for is null");
                Objects.requireNonNull(replaceWith, "replace with is null");
                if (jsonElement == null || jsonElement.isJsonNull()) break block10;
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isNumber()) {
                        if (searchFor.equals(jsonPrimitive.getAsNumber())) {
                            return new JsonPrimitive((Number)replaceWith);
                        }
                    } else if (jsonPrimitive.isBoolean()) {
                        if (searchFor.equals(jsonPrimitive.getAsBoolean())) {
                            return new JsonPrimitive((Boolean)replaceWith);
                        }
                    } else if (jsonPrimitive.isString() && searchFor.toString().equals(jsonPrimitive.getAsString())) {
                        return new JsonPrimitive(replaceWith.toString());
                    }
                    return jsonElement;
                }
                if (!jsonElement.isJsonArray()) break block11;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.set(i, AbstractRecipeProvider.searchAndReplaceValue(jsonArray.get(i), searchFor, replaceWith));
                }
                break block10;
            }
            if (!jsonElement.isJsonObject()) break block10;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                entry.setValue(AbstractRecipeProvider.searchAndReplaceValue((JsonElement)entry.getValue(), searchFor, replaceWith));
            }
        }
        return jsonElement;
    }

    public static String getHasName(class_1935 item, class_1935 ... items) {
        return "has_" + Stream.concat(Stream.of(item), Stream.of(items)).map(class_2446::method_33716).collect(Collectors.joining("_and_"));
    }

    public static class_175<class_2066.class_2068> has(class_1935 item, class_1935 ... items) {
        return AbstractRecipeProvider.method_10423((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977((class_1935[])Stream.concat(Stream.of(item), Stream.of(items)).toArray(class_1935[]::new)).method_8976()});
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        ArrayList futures = new ArrayList();
        this.method_10419(new IdentifiableRecipeOutput(output, futures));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public final void method_10419(class_8790 recipeOutput) {
        this.addRecipes(recipeOutput);
    }

    public abstract void addRecipes(class_8790 var1);

    public class IdentifiableRecipeOutput
    implements class_8790 {
        private final class_7403 output;
        private final List<CompletableFuture<?>> list;
        private final Set<class_2960> set = Sets.newHashSet();

        public IdentifiableRecipeOutput(class_7403 output, List<CompletableFuture<?>> list) {
            this.output = output;
            this.list = list;
        }

        public String getModId() {
            return AbstractRecipeProvider.this.modId;
        }

        public void method_53819(class_2960 location, class_1860<?> recipe, @Nullable class_8779 advancement) {
            class_2960 oldLocation = location;
            if (!this.set.add(location = new class_2960(AbstractRecipeProvider.this.modId, location.method_12832()))) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(location));
            }
            this.list.add(class_2405.method_53496((class_7403)this.output, (Codec)class_1860.field_47319, recipe, (Path)AbstractRecipeProvider.this.field_39378.method_44107(location)));
            if (advancement != null) {
                JsonElement jsonElement = (JsonElement)class_156.method_47526((DataResult)class_161.field_47179.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)advancement.comp_1920()), IllegalStateException::new);
                jsonElement = AbstractRecipeProvider.searchAndReplaceValue(jsonElement, oldLocation, location);
                class_2960 advancementLocation = new class_2960(AbstractRecipeProvider.this.modId, advancement.comp_1919().method_12832());
                this.list.add(class_2405.method_10320((class_7403)this.output, (JsonElement)jsonElement, (Path)AbstractRecipeProvider.this.field_39379.method_44107(advancementLocation)));
            }
        }

        public class_161.class_162 method_53818() {
            return class_161.class_162.method_51698().method_708(class_5797.field_39377);
        }
    }
}

