/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3.serialization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.network.serialization.RecordSerializer;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2379;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public final class MessageSerializers {
    private static final Map<Class<?>, MessageSerializer<?>> SERIALIZERS = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private static final Map<Class<?>, Function<Type[], MessageSerializer<?>>> CONTAINER_PROVIDERS = Collections.synchronizedMap(Maps.newLinkedHashMap());

    private MessageSerializers() {
    }

    public static <T> void registerSerializer(Class<T> type, class_2540.class_7462<T> writer, class_2540.class_7461<T> reader) {
        MessageSerializers.registerSerializer(type, new MessageSerializerImpl<T>(writer, reader));
    }

    public static <T> void registerSerializer(Class<? super T> type, class_5321<class_2378<T>> resourceKey) {
        class_2378 registry = class_7923.field_41167.method_10250(resourceKey.method_29177()) ? (class_2378)class_7923.field_41167.method_10223(resourceKey.method_29177()) : null;
        Objects.requireNonNull(registry, "Registry for key %s not found".formatted(resourceKey.method_29177()));
        MessageSerializers.registerSerializer(type, (friendlyByteBuf, t) -> friendlyByteBuf.method_10804(registry.method_10206(t)), friendlyByteBuf -> registry.method_10200(friendlyByteBuf.method_10816()));
    }

    private static <T> void registerSerializer(Class<T> type, MessageSerializer<T> value) {
        if (SERIALIZERS.put(type, value) != null) {
            PuzzlesLib.LOGGER.warn("Overriding serializer registered for type {}", type);
        }
    }

    private static <T> void registerSerializer(Class<T> type, class_2941<T> entityDataSerializer) {
        MessageSerializers.registerSerializer(type, (arg_0, arg_1) -> entityDataSerializer.method_12715(arg_0, arg_1), arg_0 -> entityDataSerializer.method_12716(arg_0));
    }

    public static <T> void registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
        if (CONTAINER_PROVIDERS.put(type, factory) != null) {
            PuzzlesLib.LOGGER.warn("Overriding collection provider registered for type {}", type);
        }
    }

    public static <T> MessageSerializer<T> findByType(Class<T> type) {
        MessageSerializer<Object> serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            serializer = MessageSerializers.computeIfAbsent(type);
            SERIALIZERS.put(type, serializer);
        }
        return serializer;
    }

    private static <T, E extends Enum<E>> MessageSerializer<T> computeIfAbsent(Class<T> clazz) {
        if (Record.class.isAssignableFrom(clazz)) {
            return RecordSerializer.createRecordSerializer(clazz);
        }
        if (clazz.isArray()) {
            return MessageSerializers.createArraySerializer(clazz.getComponentType());
        }
        if (clazz.isEnum()) {
            return MessageSerializers.createEnumSerializer(clazz);
        }
        throw new RuntimeException("Missing serializer for type %s".formatted(clazz));
    }

    @ApiStatus.Internal
    public static MessageSerializer<?> findByGenericType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return MessageSerializers.findByType(clazz);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        for (Map.Entry<Class<?>, Function<Type[], MessageSerializer<?>>> entry : CONTAINER_PROVIDERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue().apply(typeArguments);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return MessageSerializers.createCollectionSerializer(typeArguments, Sets::newLinkedHashSetWithExpectedSize);
        }
        return MessageSerializers.findByType(clazz);
    }

    private static <K, V> MessageSerializer<Map<K, V>> createMapSerializer(Type[] typeArguments) {
        MessageSerializer keySerializer = MessageSerializers.findByType((Class)typeArguments[0]);
        MessageSerializer valueSerializer = MessageSerializers.findByType((Class)typeArguments[1]);
        return new MessageSerializerImpl<Map<K, V>>((friendlyByteBuf, o) -> friendlyByteBuf.method_34063(o, keySerializer::write, valueSerializer::write), friendlyByteBuf -> friendlyByteBuf.method_34067(keySerializer::read, valueSerializer::read));
    }

    private static <T, C extends Collection<T>> MessageSerializer<C> createCollectionSerializer(Type[] typeArguments, IntFunction<C> factory) {
        MessageSerializer serializer = MessageSerializers.findByType((Class)typeArguments[0]);
        return new MessageSerializerImpl((friendlyByteBuf, o) -> friendlyByteBuf.method_34062(o, serializer::write), friendlyByteBuf -> friendlyByteBuf.method_34068(factory, serializer::read));
    }

    private static <T> MessageSerializer<Optional<T>> createOptionalSerializer(Type[] typeArguments) {
        MessageSerializer serializer = MessageSerializers.findByType((Class)typeArguments[0]);
        return new MessageSerializerImpl<Optional<T>>((friendlyByteBuf, o) -> friendlyByteBuf.method_37435(o, serializer::write), friendlyByteBuf -> friendlyByteBuf.method_37436(serializer::read));
    }

    private static <L, R> MessageSerializer<Either<L, R>> createEitherSerializer(Type[] typeArguments) {
        MessageSerializer leftSerializer = MessageSerializers.findByType((Class)typeArguments[0]);
        MessageSerializer rightSerializer = MessageSerializers.findByType((Class)typeArguments[1]);
        return new MessageSerializerImpl<Either<L, R>>((friendlyByteBuf, o) -> friendlyByteBuf.method_43619(o, leftSerializer::write, rightSerializer::write), friendlyByteBuf -> friendlyByteBuf.method_43622(leftSerializer::read, rightSerializer::read));
    }

    private static MessageSerializer<?> createArraySerializer(Class<?> clazz) {
        MessageSerializer<?> serializer = MessageSerializers.findByType(clazz);
        return new MessageSerializerImpl((buf, t) -> {
            int length = Array.getLength(t);
            buf.method_10804(length);
            for (int i = 0; i < length; ++i) {
                serializer.write((class_2540)buf, Array.get(t, i));
            }
        }, buf -> {
            int length = buf.method_10816();
            Object array = Array.newInstance(clazz, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, serializer.read((class_2540)buf));
            }
            return array;
        });
    }

    private static <E extends Enum<E>> MessageSerializer<E> createEnumSerializer(Class<E> clazz) {
        return new MessageSerializerImpl(class_2540::method_10817, buf -> buf.method_10818(clazz));
    }

    static {
        MessageSerializers.registerSerializer(Boolean.TYPE, class_2540::method_52964, class_2540::readBoolean);
        MessageSerializers.registerSerializer(Boolean.class, class_2540::method_52964, class_2540::readBoolean);
        MessageSerializers.registerSerializer(Integer.TYPE, class_2540::method_10804, class_2540::method_10816);
        MessageSerializers.registerSerializer(Integer.class, class_2540::method_10804, class_2540::method_10816);
        MessageSerializers.registerSerializer(Long.TYPE, class_2540::method_10791, class_2540::method_10792);
        MessageSerializers.registerSerializer(Long.class, class_2540::method_10791, class_2540::method_10792);
        MessageSerializers.registerSerializer(Float.TYPE, class_2540::method_52941, class_2540::readFloat);
        MessageSerializers.registerSerializer(Float.class, class_2540::method_52941, class_2540::readFloat);
        MessageSerializers.registerSerializer(Double.TYPE, class_2540::method_52940, class_2540::readDouble);
        MessageSerializers.registerSerializer(Double.class, class_2540::method_52940, class_2540::readDouble);
        MessageSerializers.registerSerializer(Byte.TYPE, class_2540::method_52997, class_2540::readByte);
        MessageSerializers.registerSerializer(Byte.class, class_2540::method_52997, class_2540::readByte);
        MessageSerializers.registerSerializer(Short.TYPE, class_2540::method_52998, class_2540::readShort);
        MessageSerializers.registerSerializer(Short.class, class_2540::method_52998, class_2540::readShort);
        MessageSerializers.registerSerializer(Character.TYPE, class_2540::method_53004, class_2540::readChar);
        MessageSerializers.registerSerializer(Character.class, class_2540::method_53004, class_2540::readChar);
        MessageSerializers.registerSerializer(String.class, class_2943.field_13326);
        MessageSerializers.registerSerializer(Date.class, class_2540::method_10796, class_2540::method_10802);
        MessageSerializers.registerSerializer(Instant.class, class_2540::method_44115, class_2540::method_44118);
        MessageSerializers.registerSerializer(UUID.class, class_2540::method_10797, class_2540::method_10790);
        MessageSerializers.registerSerializer(class_2561.class, class_2943.field_13317);
        MessageSerializers.registerSerializer(class_1799.class, class_2943.field_13322);
        MessageSerializers.registerSerializer(class_2379.class, class_2943.field_13316);
        MessageSerializers.registerSerializer(class_2338.class, class_2943.field_13324);
        MessageSerializers.registerSerializer(class_2350.class, class_2943.field_13321);
        MessageSerializers.registerSerializer(class_2487.class, class_2943.field_13318);
        MessageSerializers.registerSerializer(class_2394.class, class_2943.field_13314);
        MessageSerializers.registerSerializer(class_3850.class, class_2943.field_17207);
        MessageSerializers.registerSerializer(class_4050.class, class_2943.field_18238);
        MessageSerializers.registerSerializer(class_1923.class, class_2540::method_36130, class_2540::method_36133);
        MessageSerializers.registerSerializer(class_2960.class, class_2540::method_10812, class_2540::method_10810);
        MessageSerializers.registerSerializer(class_3965.class, class_2540::method_17813, class_2540::method_17814);
        MessageSerializers.registerSerializer(BitSet.class, class_2540::method_33557, class_2540::method_33558);
        MessageSerializers.registerSerializer(GameProfile.class, class_2540::method_43616, class_2540::method_43623);
        MessageSerializers.registerSerializer(class_243.class, (friendlyByteBuf, vec3) -> {
            friendlyByteBuf.method_52940(vec3.method_10216());
            friendlyByteBuf.method_52940(vec3.method_10214());
            friendlyByteBuf.method_52940(vec3.method_10215());
        }, friendlyByteBuf -> new class_243(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble()));
        MessageSerializers.registerSerializer(Vector3f.class, (friendlyByteBuf, vec3) -> {
            friendlyByteBuf.method_52941(vec3.x());
            friendlyByteBuf.method_52941(vec3.y());
            friendlyByteBuf.method_52941(vec3.z());
        }, friendlyByteBuf -> new Vector3f(friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat()));
        MessageSerializers.registerSerializer(class_2540.class, (buf, other) -> {
            buf.method_10804(other.readableBytes());
            buf.method_52975((ByteBuf)other);
            other.release();
        }, buf -> new class_2540(buf.readBytes(buf.method_10816())));
        MessageSerializers.registerSerializer(class_3414.class, class_7924.field_41225);
        MessageSerializers.registerSerializer(class_3611.class, class_7924.field_41270);
        MessageSerializers.registerSerializer(class_1291.class, class_7924.field_41208);
        MessageSerializers.registerSerializer(class_2248.class, class_7924.field_41254);
        MessageSerializers.registerSerializer(class_1887.class, class_7924.field_41265);
        MessageSerializers.registerSerializer(class_1299.class, class_7924.field_41266);
        MessageSerializers.registerSerializer(class_1792.class, class_7924.field_41197);
        MessageSerializers.registerSerializer(class_1842.class, class_7924.field_41215);
        MessageSerializers.registerSerializer(class_2396.class, class_7924.field_41210);
        MessageSerializers.registerSerializer(class_2591.class, class_7924.field_41255);
        MessageSerializers.registerSerializer(class_3917.class, class_7924.field_41207);
        MessageSerializers.registerSerializer(class_1320.class, class_7924.field_41251);
        MessageSerializers.registerSerializer(class_5712.class, class_7924.field_41273);
        MessageSerializers.registerSerializer(class_3854.class, class_7924.field_41235);
        MessageSerializers.registerSerializer(class_3852.class, class_7924.field_41234);
        MessageSerializers.registerSerializer(class_4158.class, class_7924.field_41212);
        MessageSerializers.registerContainerProvider(Map.class, MessageSerializers::createMapSerializer);
        MessageSerializers.registerContainerProvider(List.class, typeArguments -> MessageSerializers.createCollectionSerializer(typeArguments, Lists::newArrayListWithExpectedSize));
        MessageSerializers.registerContainerProvider(Optional.class, MessageSerializers::createOptionalSerializer);
        MessageSerializers.registerContainerProvider(Either.class, MessageSerializers::createEitherSerializer);
    }

    private record MessageSerializerImpl<T>(class_2540.class_7462<T> writer, class_2540.class_7461<T> reader) implements MessageSerializer<T>
    {
        @Override
        public void write(class_2540 buf, T instance) {
            this.writer.accept((Object)buf, instance);
        }

        @Override
        public T read(class_2540 buf) {
            return (T)this.reader.apply((Object)buf);
        }
    }
}

