/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.network;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.fabric.impl.core.FabricProxy;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistryImpl;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8705;
import net.minecraft.class_8706;

public class NetworkHandlerFabricV3
extends NetworkHandlerRegistryImpl {
    private boolean building = true;

    public NetworkHandlerFabricV3(class_2960 channelName) {
        super(channelName);
    }

    @Override
    public <T extends Record> void registerClientbound$Internal(Class<?> clazz) {
        this.register(clazz, ((FabricProxy)Proxy.INSTANCE)::registerClientReceiver);
    }

    @Override
    public <T extends Record> void registerServerbound$Internal(Class<?> clazz) {
        this.register(clazz, ((FabricProxy)Proxy.INSTANCE)::registerServerReceiver);
    }

    private <T> void register(Class<T> clazz, BiConsumer<class_2960, Function<class_2540, T>> register) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        register.accept(this.registerMessageType(clazz), MessageSerializers.findByType(clazz)::read);
    }

    @Override
    public <T extends Record> class_2596<class_8705> toClientboundPacket(T message) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    @Override
    public <T extends Record> class_2596<class_8706> toServerboundPacket(T message) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    private <T extends Record, S extends class_2547> class_2596<S> toPacket(BiFunction<class_2960, class_2540, class_2596<S>> packetFactory, T message) {
        return this.toPacket(message, (resourceLocation, consumer) -> {
            class_2540 friendlyByteBuf = PacketByteBufs.create();
            consumer.accept(friendlyByteBuf);
            return (class_2596)packetFactory.apply((class_2960)resourceLocation, friendlyByteBuf);
        });
    }

    @Override
    public void build() {
        this.building = false;
        super.build();
    }
}

