/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.core.v1.utility.EnvironmentAwareBuilder;
import fuzs.puzzleslib.api.init.v3.registry.MenuSupplierWithData;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.init.DyedSpawnEggItem;
import fuzs.puzzleslib.impl.item.CreativeModeTabHelper;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;

public interface RegistryManager
extends EnvironmentAwareBuilder<RegistryManager> {
    public static RegistryManager from(String modId) {
        return ModContext.get(modId).getRegistryManager();
    }

    default public <T> ResourceKey<T> makeResourceKey(ResourceKey<? extends Registry<? super T>> registryKey, String path) {
        return ResourceKey.create(registryKey, (ResourceLocation)this.makeKey(path));
    }

    public ResourceLocation makeKey(String var1);

    @Deprecated(forRemoval=true)
    default public String makeDescriptionId(ResourceKey<? extends Registry<?>> registryKey, String path) {
        return Util.makeDescriptionId((String)Registries.elementsDirPath(registryKey), (ResourceLocation)this.makeKey(path));
    }

    public <T> Holder.Reference<T> registerLazily(ResourceKey<? extends Registry<? super T>> var1, String var2);

    public <T> Holder.Reference<T> register(ResourceKey<? extends Registry<? super T>> var1, String var2, Supplier<T> var3);

    default public Holder.Reference<Block> registerBlock(String path, Supplier<BlockBehaviour.Properties> blockPropertiesSupplier) {
        return this.registerBlock(path, Block::new, blockPropertiesSupplier);
    }

    default public Holder.Reference<Block> registerBlock(String path, Function<BlockBehaviour.Properties, Block> blockFactory, Supplier<BlockBehaviour.Properties> blockPropertiesSupplier) {
        return this.register(Registries.BLOCK, path, () -> (Block)blockFactory.apply(((BlockBehaviour.Properties)blockPropertiesSupplier.get()).setId(this.makeResourceKey(Registries.BLOCK, path))));
    }

    default public Holder.Reference<Item> registerItem(String path) {
        return this.registerItem(path, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerItem(String path, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.registerItem(path, Item::new, itemPropertiesSupplier);
    }

    default public Holder.Reference<Item> registerItem(String path, Function<Item.Properties, Item> itemFactory) {
        return this.registerItem(path, itemFactory, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerItem(String path, Function<Item.Properties, Item> itemFactory, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.register(Registries.ITEM, path, () -> (Item)itemFactory.apply(((Item.Properties)itemPropertiesSupplier.get()).setId(this.makeResourceKey(Registries.ITEM, path))));
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block) {
        return this.registerBlockItem(block, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.registerBlockItem(block, BlockItem::new, itemPropertiesSupplier);
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block, BiFunction<Block, Item.Properties, ? extends BlockItem> itemFactory) {
        return this.registerBlockItem(block, itemFactory, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block, BiFunction<Block, Item.Properties, ? extends BlockItem> itemFactory, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.registerItem(((ResourceKey)block.unwrapKey().orElseThrow()).location().getPath(), itemProperties -> (Item)itemFactory.apply((Block)block.value(), (Item.Properties)itemProperties), () -> ((Item.Properties)itemPropertiesSupplier.get()).useBlockDescriptionPrefix());
    }

    default public Holder.Reference<Item> registerSpawnEggItem(Holder<? extends EntityType<? extends Mob>> entityTypeHolder, int backgroundColor) {
        return this.registerSpawnEggItem(entityTypeHolder, backgroundColor, DyedSpawnEggItem.generateHighlightColor(backgroundColor));
    }

    default public Holder.Reference<Item> registerSpawnEggItem(Holder<? extends EntityType<? extends Mob>> entityTypeHolder, int backgroundColor, int highlightColor) {
        return this.registerSpawnEggItem(entityTypeHolder, backgroundColor, highlightColor, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerSpawnEggItem(Holder<? extends EntityType<? extends Mob>> entityTypeHolder, int backgroundColor, int highlightColor, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.registerItem(((ResourceKey)entityTypeHolder.unwrapKey().orElseThrow()).location().getPath() + "_spawn_egg", itemProperties -> new DyedSpawnEggItem((EntityType<? extends Mob>)((EntityType)entityTypeHolder.value()), backgroundColor, highlightColor, (Item.Properties)itemProperties), itemPropertiesSupplier);
    }

    default public Holder.Reference<CreativeModeTab> registerCreativeModeTab(Holder<? extends ItemLike> iconHolder) {
        return this.registerCreativeModeTab(() -> new ItemStack((ItemLike)iconHolder.value()));
    }

    default public Holder.Reference<CreativeModeTab> registerCreativeModeTab(Supplier<ItemStack> iconSupplier) {
        ResourceLocation resourceLocation = this.makeKey("main");
        return this.registerCreativeModeTab(resourceLocation.getPath(), iconSupplier, CreativeModeTabHelper.getDisplayItems(resourceLocation.getNamespace()), false);
    }

    default public Holder.Reference<CreativeModeTab> registerCreativeModeTab(Supplier<ItemStack> iconSupplier, CreativeModeTab.DisplayItemsGenerator displayItems) {
        return this.registerCreativeModeTab("main", iconSupplier, displayItems, false);
    }

    public Holder.Reference<CreativeModeTab> registerCreativeModeTab(String var1, Supplier<ItemStack> var2, CreativeModeTab.DisplayItemsGenerator var3, boolean var4);

    default public <T> Holder.Reference<DataComponentType<T>> registerDataComponentType(String path, UnaryOperator<DataComponentType.Builder<T>> operator) {
        return this.register(Registries.DATA_COMPONENT_TYPE, path, () -> ((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build());
    }

    default public Holder.Reference<Fluid> registerFluid(String path, Supplier<Fluid> fluidSupplier) {
        return this.register(Registries.FLUID, path, fluidSupplier);
    }

    default public Holder.Reference<MobEffect> registerMobEffect(String path, Supplier<MobEffect> mobEffectSupplier) {
        return this.register(Registries.MOB_EFFECT, path, mobEffectSupplier);
    }

    default public Holder.Reference<SoundEvent> registerSoundEvent(String path) {
        return this.register(Registries.SOUND_EVENT, path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)this.makeKey(path)));
    }

    default public Holder.Reference<Potion> registerPotion(String path, Supplier<Potion> potionSupplier) {
        return this.registerPotion(path, (String name) -> (Potion)potionSupplier.get());
    }

    default public Holder.Reference<Potion> registerPotion(String path, Function<String, Potion> potionFactory) {
        return this.register(Registries.POTION, path, () -> (Potion)potionFactory.apply(path));
    }

    default public ResourceKey<Enchantment> registerEnchantment(String path) {
        return this.makeResourceKey(Registries.ENCHANTMENT, path);
    }

    default public <T> Holder.Reference<DataComponentType<T>> registerEnchantmentEffectComponentType(String path, UnaryOperator<DataComponentType.Builder<T>> operator) {
        return this.register(Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, path, () -> ((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build());
    }

    default public <T extends Entity> Holder.Reference<EntityType<T>> registerEntityType(String path, Supplier<EntityType.Builder<T>> entityTypeSupplier) {
        return this.register(Registries.ENTITY_TYPE, path, () -> ((EntityType.Builder)entityTypeSupplier.get()).build(this.makeResourceKey(Registries.ENTITY_TYPE, path)));
    }

    default public <T extends BlockEntity> Holder.Reference<BlockEntityType<T>> registerBlockEntityType(String path, BiFunction<BlockPos, BlockState, T> blockEntityFactory, Holder<Block> validBlock) {
        return this.registerBlockEntityType(path, blockEntityFactory, () -> Collections.singleton((Block)validBlock.value()));
    }

    public <T extends BlockEntity> Holder.Reference<BlockEntityType<T>> registerBlockEntityType(String var1, BiFunction<BlockPos, BlockState, T> var2, Supplier<Set<Block>> var3);

    default public <T extends AbstractContainerMenu> Holder.Reference<MenuType<T>> registerMenuType(String path, MenuType.MenuSupplier<T> menuSupplier) {
        return this.register(Registries.MENU, path, () -> new MenuType(menuSupplier, FeatureFlags.DEFAULT_FLAGS));
    }

    public <T extends AbstractContainerMenu, S> Holder.Reference<MenuType<T>> registerMenuType(String var1, MenuSupplierWithData<T, S> var2, StreamCodec<? super RegistryFriendlyByteBuf, S> var3);

    default public Holder.Reference<PoiType> registerPoiType(String path, Holder<Block> matchingBlock) {
        return this.registerPoiType(path, () -> Collections.singleton((Block)matchingBlock.value()));
    }

    default public Holder.Reference<PoiType> registerPoiType(String path, Supplier<Set<Block>> matchingBlocks) {
        return this.registerPoiType(path, 0, 1, () -> (Set)((Set)matchingBlocks.get()).stream().flatMap(block -> block.getStateDefinition().getPossibleStates().stream()).collect(ImmutableSet.toImmutableSet()));
    }

    public Holder.Reference<PoiType> registerPoiType(String var1, int var2, int var3, Supplier<Set<BlockState>> var4);

    default public <A extends ArgumentType<?>> Holder.Reference<ArgumentTypeInfo<?, ?>> registerArgumentType(String path, Class<? extends A> argumentClass, Supplier<A> argumentType) {
        return this.registerArgumentType(path, argumentClass, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(argumentType));
    }

    public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> Holder.Reference<ArgumentTypeInfo<?, ?>> registerArgumentType(String var1, Class<? extends A> var2, ArgumentTypeInfo<A, T> var3);

    default public <T extends Recipe<?>> Holder.Reference<RecipeType<T>> registerRecipeType(String path) {
        return this.register(Registries.RECIPE_TYPE, path, () -> {
            final ResourceLocation resourceLocation = this.makeKey(path);
            return new RecipeType<T>(this){

                public String toString() {
                    return "RecipeType[" + String.valueOf(resourceLocation) + "]";
                }
            };
        });
    }

    default public Holder.Reference<RecipeBookCategory> registerRecipeBookCategory(String path) {
        return this.register(Registries.RECIPE_BOOK_CATEGORY, path, () -> {
            final ResourceLocation resourceLocation = this.makeKey(path);
            return new RecipeBookCategory(this){

                public String toString() {
                    return "RecipeBookCategory[" + String.valueOf(resourceLocation) + "]";
                }
            };
        });
    }

    default public Holder.Reference<GameEvent> registerGameEvent(String path, int notificationRadius) {
        return this.register(Registries.GAME_EVENT, path, () -> new GameEvent(notificationRadius));
    }

    default public Holder.Reference<SimpleParticleType> registerParticleType(String path) {
        return this.register(Registries.PARTICLE_TYPE, path, () -> new SimpleParticleType(false));
    }

    default public <T extends ParticleOptions> Holder.Reference<ParticleType<T>> registerParticleType(String path, boolean overrideLimiter, final Function<ParticleType<T>, MapCodec<T>> codecGetter, final Function<ParticleType<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodecGetter) {
        return this.register(Registries.PARTICLE_TYPE, path, () -> new ParticleType<T>(this, overrideLimiter){

            public MapCodec<T> codec() {
                return (MapCodec)codecGetter.apply(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return (StreamCodec)streamCodecGetter.apply(this);
            }
        });
    }

    default public Holder.Reference<Attribute> registerAttribute(String path, double defaultValue, double minValue, double maxValue) {
        return this.registerAttribute(path, defaultValue, minValue, maxValue, true, Attribute.Sentiment.POSITIVE);
    }

    default public Holder.Reference<Attribute> registerAttribute(String path, double defaultValue, double minValue, double maxValue, boolean syncable, Attribute.Sentiment sentiment) {
        Objects.requireNonNull(sentiment, "sentiment is null");
        return this.register(Registries.ATTRIBUTE, path, () -> {
            String descriptionId = this.makeKey(path).toLanguageKey(Registries.elementsDirPath((ResourceKey)Registries.ATTRIBUTE));
            return new RangedAttribute(descriptionId, defaultValue, minValue, maxValue).setSyncable(syncable).setSentiment(sentiment);
        });
    }

    public <T> Holder.Reference<EntityDataSerializer<T>> registerEntityDataSerializer(String var1, Supplier<EntityDataSerializer<T>> var2);

    default public ResourceKey<DamageType> registerDamageType(String path) {
        return this.makeResourceKey(Registries.DAMAGE_TYPE, path);
    }

    default public ResourceKey<TrimMaterial> registerTrimMaterial(String path) {
        return this.makeResourceKey(Registries.TRIM_MATERIAL, path);
    }

    default public ResourceKey<LootTable> registerLootTable(String path) {
        return this.makeResourceKey(Registries.LOOT_TABLE, path);
    }

    public <T> void prepareTag(ResourceKey<? extends Registry<? super T>> var1, TagKey<T> var2);
}

