/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.chat;

import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;

public class StyleCombiningCharSink
implements FormattedCharSink {
    private final List<Map.Entry<StringBuilder, Style>> stringBuilders = new ArrayList<Map.Entry<StringBuilder, Style>>(List.of(Map.entry(new StringBuilder(), Style.EMPTY)));

    public boolean accept(int width, Style style, int codePoint) {
        StringBuilder stringBuilder;
        Map.Entry<StringBuilder, Style> entry = this.stringBuilders.getLast();
        if (entry.getValue() == style || entry.getValue().isEmpty() && style.isEmpty()) {
            stringBuilder = entry.getKey();
        } else {
            stringBuilder = new StringBuilder();
            this.stringBuilders.add(Map.entry(stringBuilder, style));
        }
        stringBuilder.appendCodePoint(codePoint);
        return true;
    }

    public Component getAsComponent() {
        Stream.Builder builder = Stream.builder();
        this.iterate((string, style) -> builder.accept(Component.literal((String)string).withStyle(style)));
        return (Component)builder.build().reduce(MutableComponent::append).orElseGet(Component::empty);
    }

    public String getAsString() {
        StringBuilder builder = new StringBuilder();
        this.iterate((string, style) -> {
            if (!style.isEmpty()) {
                builder.append(ComponentHelper.getAsString(style));
            }
            builder.append((String)string);
            if (!style.isEmpty()) {
                builder.append(ChatFormatting.RESET);
            }
        });
        return builder.toString();
    }

    private void iterate(BiConsumer<String, Style> componentConsumer) {
        for (Map.Entry<StringBuilder, Style> entry : this.stringBuilders) {
            if (entry.getKey().isEmpty() && entry.getValue().isEmpty()) continue;
            Style style = ComponentHelper.sanitizeLegacyFormat(entry.getValue());
            componentConsumer.accept(entry.getKey().toString(), style);
        }
    }

    @FunctionalInterface
    public static interface FormattedContentComposer<T>
    extends Function<StyleCombiningCharSink, T> {
    }
}

