/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.core.proxy;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.client.renderer.v1.RenderPropertyKey;
import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import fuzs.puzzleslib.impl.core.context.ModConstructorImpl;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.Nullable;

public interface ClientProxyImpl
extends ProxyImpl {
    public static ClientProxyImpl get() {
        return (ClientProxyImpl)ProxyImpl.INSTANCE;
    }

    public ModConstructorImpl<ClientModConstructor> getClientModConstructorImpl();

    public KeyMappingHelper getKeyMappingActivationHelper();

    @Nullable
    public <T> T getRenderProperty(EntityRenderState var1, RenderPropertyKey<T> var2);

    public <T> void setRenderProperty(EntityRenderState var1, RenderPropertyKey<T> var2, @Nullable T var3);

    @Deprecated(forRemoval=true)
    public void registerBuiltinResourcePack(ResourceLocation var1, Component var2, boolean var3);

    public float getPartialTick(EntityRenderState var1);

    public boolean isKeyActiveAndMatches(KeyMapping var1, int var2, int var3);

    public ClientTooltipComponent createImageComponent(TooltipComponent var1);

    public boolean onRenderTooltip(GuiGraphics var1, Font var2, int var3, int var4, List<ClientTooltipComponent> var5, ClientTooltipPositioner var6);

    public BakedQuad copyBakedQuad(BakedQuad var1);

    public boolean isEffectVisibleInInventory(MobEffectInstance var1);

    public boolean isEffectVisibleInGui(MobEffectInstance var1);

    public void registerWoodType(WoodType var1);

    public int getLeftStatusBarHeight(ResourceLocation var1);

    public int getRightStatusBarHeight(ResourceLocation var1);

    public <E extends Entity, S extends EntityRenderState> void onUpdateEntityRenderState(EntityRenderer<E, S> var1, E var2, S var3, float var4);

    @Override
    default public BlockableEventLoop<? super TickTask> getBlockableEventLoop(Level level) {
        if (level.isClientSide()) {
            return Minecraft.getInstance();
        }
        return ProxyImpl.super.getBlockableEventLoop(level);
    }

    @Override
    default public RegistryAccess getRegistryAccess() {
        return Minecraft.getInstance().getConnection() != null ? Minecraft.getInstance().getConnection().registryAccess() : null;
    }

    @Override
    default public Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    default public Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    @Override
    default public ClientGamePacketListener getClientPacketListener() {
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        Objects.requireNonNull(clientPacketListener, "client packet listener is null");
        return clientPacketListener;
    }

    @Override
    default public boolean hasControlDown() {
        return Screen.hasControlDown();
    }

    @Override
    default public boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    @Override
    default public boolean hasAltDown() {
        return Screen.hasAltDown();
    }

    @Override
    default public List<Component> splitTooltipLines(Component component) {
        return ClientComponentSplitter.splitTooltipLines(new FormattedText[]{component}).map(ComponentHelper::getAsComponent).toList();
    }
}

