/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config.serialization;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.config.serialization.RegistryProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigDataSetImpl<T>
implements ConfigDataSet<T> {
    private static final Set<Class<?>> SUPPORTED_DATA_TYPES = ImmutableSet.of(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Double.TYPE, Double.class, (Object[])new Class[]{String.class});
    private final KeyedValueProvider<T> valueProvider;
    private final List<EntryHolder<?, T>> values = new ArrayList();
    private final BiPredicate<Integer, Object> filter;
    private final int dataSize;
    private Map<T, Object[]> dissolved;

    public ConfigDataSetImpl(KeyedValueProvider<T> valueProvider, List<String> values, BiPredicate<Integer, Object> filter, Class<?> ... types) {
        this.valueProvider = valueProvider;
        this.filter = filter;
        for (Class<?> clazz : types) {
            if (SUPPORTED_DATA_TYPES.contains(clazz)) continue;
            throw new IllegalArgumentException("Data type of clazz %s is not supported".formatted(clazz));
        }
        this.dataSize = types.length;
        for (String value : values) {
            this.deserialize(value, types).ifPresent(this.values::add);
        }
        TagsUpdatedCallback.EVENT.register((registryAccess, client) -> {
            this.dissolved = null;
        });
    }

    private static Object deserializeData(Class<?> clazz, String source) throws RuntimeException {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (source.equals("true")) {
                return true;
            }
            if (source.equals("false")) {
                return false;
            }
            throw new IllegalArgumentException("%s is not a boolean value".formatted(source));
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.parseInt(source);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.parseDouble(source);
        }
        if (clazz == String.class) {
            return source;
        }
        throw new IllegalArgumentException("Data type of clazz %s is not supported".formatted(clazz));
    }

    @Override
    public Map<T, Object[]> toMap() {
        return this.dissolve();
    }

    @Override
    public Set<T> toSet() {
        return this.toMap().keySet();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toSet().iterator();
    }

    @Override
    public int size() {
        return this.toMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.toMap().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.toSet().contains(o);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toSet().toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        return this.toSet().toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.toSet().add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.toSet().remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.toSet().containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        return this.toSet().addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.toSet().removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.toSet().retainAll(c);
    }

    @Override
    public void clear() {
        this.toMap().clear();
    }

    @Override
    @Nullable
    public Object[] get(T entry) {
        return this.toMap().get(entry);
    }

    @Override
    public <V> V get(T entry, int index) {
        Objects.checkIndex(index, this.dataSize);
        Object[] data = this.get(entry);
        Objects.requireNonNull(data, "data is null");
        return (V)data[index];
    }

    @Override
    public <V> Optional<V> getOptional(T entry, int index) {
        if (index < 0 || index >= this.dataSize) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.get(entry)).map(data -> data[index]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ConfigDataSet)) return false;
        ConfigDataSet impl = (ConfigDataSet)o;
        if (!this.toMap().equals(impl.toMap())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.toMap().hashCode();
    }

    private Map<T, Object[]> dissolve() {
        Map<Object, Object> dissolved = this.dissolved;
        if (dissolved == null) {
            Map entries = new IdentityHashMap();
            Set toRemove = Sets.newIdentityHashSet();
            for (EntryHolder<?, T> holder : this.values) {
                if (!(holder instanceof TagEntryHolder)) continue;
                holder.dissolve(holder.inverted ? (t, objects) -> toRemove.add(t) : entries::put);
            }
            for (EntryHolder<?, T> holder : this.values) {
                if (!(holder instanceof RegistryEntryHolder)) continue;
                holder.dissolve(holder.inverted ? (t, objects) -> toRemove.add(t) : entries::put);
            }
            if (entries.isEmpty() && !toRemove.isEmpty()) {
                entries = this.valueProvider.streamValues().collect(Collectors.toMap(Function.identity(), t -> EntryHolder.EMPTY_DATA, (o1, o2) -> o1, Maps::newIdentityHashMap));
            }
            entries.keySet().removeIf(t -> !this.filter.test(0, t) || toRemove.contains(t));
            this.dissolved = dissolved = Collections.unmodifiableMap(entries);
        }
        return dissolved;
    }

    private Optional<EntryHolder<?, T>> deserialize(String source, Class<?>[] types) {
        String[] sources = source.trim().split(",");
        try {
            String newSource = sources[0].trim();
            if (!newSource.startsWith("!")) {
                Object[] data = new Object[types.length];
                for (int i = 0; i < types.length; ++i) {
                    if (sources.length - 1 <= i) {
                        throw new IllegalArgumentException("Data index out of bounds, index was %s, but length is %s".formatted(i + 1, sources.length));
                    }
                    data[i] = ConfigDataSetImpl.deserializeData(types[i], sources[i + 1].trim());
                    if (this.filter.test(i + 1, data[i])) continue;
                    throw new IllegalStateException("Data %s at index %s from source entry %s does not conform to filter".formatted(data[i], i, source));
                }
                return Optional.of(this.deserialize(newSource).withData(data));
            }
            return Optional.of(this.deserialize(newSource));
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.warn("Unable to parse entry {}", (Object)source, (Object)e);
            return Optional.empty();
        }
    }

    private EntryHolder<?, T> deserialize(String source) throws RuntimeException {
        boolean tagHolder;
        boolean inverted = ((String)source).startsWith("!");
        if (inverted) {
            source = ((String)source).substring(1);
        }
        if (tagHolder = ((String)source).startsWith("#")) {
            source = ((String)source).substring(1);
        }
        if (!((String)source).contains(":")) {
            source = "minecraft:" + (String)source;
        }
        if (tagHolder) {
            KeyedValueProvider<T> keyedValueProvider = this.valueProvider;
            if (keyedValueProvider instanceof RegistryProvider) {
                RegistryProvider registryProvider = (RegistryProvider)keyedValueProvider;
                return new TagEntryHolder(registryProvider, (String)source, inverted);
            }
            throw new IllegalArgumentException("Value provider %s does not support tags!".formatted(this.valueProvider.name()));
        }
        return new RegistryEntryHolder<T>(this.valueProvider, (String)source, inverted);
    }

    private static abstract class EntryHolder<D, E> {
        public static final Object[] EMPTY_DATA = new Object[0];
        private final String providerName;
        public final boolean inverted;
        private final String input;
        private Object[] data = EMPTY_DATA;

        protected EntryHolder(String providerName, String input, boolean inverted) {
            this.providerName = providerName;
            this.input = input;
            this.inverted = inverted;
        }

        public EntryHolder<D, E> withData(Object[] data) {
            this.data = data;
            return this;
        }

        public final void dissolve(BiConsumer<E, Object[]> builder) {
            this.findRegistryMatches(this.input).stream().flatMap(this::dissolveValue).forEach(value -> builder.accept(value, this.data));
        }

        private Collection<D> findRegistryMatches(String s) {
            HashSet matches = Sets.newHashSet();
            if (!s.contains("*")) {
                Optional.ofNullable(ResourceLocationHelper.tryParse(s)).flatMap(this::toValue).ifPresent(matches::add);
            } else {
                String regexSource = s.replace("*", "[a-z0-9/._-]*");
                this.allValues().filter(entry -> ((ResourceLocation)entry.getKey()).toString().matches(regexSource)).map(Map.Entry::getValue).forEach(matches::add);
            }
            if (matches.isEmpty()) {
                PuzzlesLib.LOGGER.warn("Unable to parse entry {}: No matches found in {}", (Object)s, (Object)this.providerName);
            }
            return matches;
        }

        protected abstract Stream<E> dissolveValue(D var1);

        protected abstract Optional<D> toValue(ResourceLocation var1);

        protected abstract Stream<Map.Entry<ResourceLocation, D>> allValues();
    }

    private static class TagEntryHolder<T>
    extends EntryHolder<TagKey<T>, T> {
        private final Registry<T> registry;

        TagEntryHolder(RegistryProvider<T> registryProvider, String source, boolean inverted) {
            super(registryProvider.name(), source, inverted);
            this.registry = registryProvider.registry();
        }

        @Override
        public Stream<T> dissolveValue(TagKey<T> entry) {
            return StreamSupport.stream(this.registry.getTagOrEmpty(entry).spliterator(), false).map(Holder::value);
        }

        @Override
        protected Optional<TagKey<T>> toValue(ResourceLocation resourceLocation) {
            TagKey tag = TagKey.create((ResourceKey)this.registry.key(), (ResourceLocation)resourceLocation);
            if (this.registry.get(tag).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(tag);
        }

        @Override
        protected Stream<Map.Entry<ResourceLocation, TagKey<T>>> allValues() {
            return this.registry.listTagIds().map(tagKey -> Map.entry(tagKey.location(), tagKey));
        }
    }

    private static class RegistryEntryHolder<T>
    extends EntryHolder<T, T> {
        private final KeyedValueProvider<T> valueProvider;

        RegistryEntryHolder(KeyedValueProvider<T> valueProvider, String source, boolean inverted) {
            super(valueProvider.name(), source, inverted);
            this.valueProvider = valueProvider;
        }

        @Override
        protected Stream<T> dissolveValue(T entry) {
            return Stream.of(entry);
        }

        @Override
        protected Optional<T> toValue(ResourceLocation resourceLocation) {
            return this.valueProvider.getValue(resourceLocation);
        }

        @Override
        protected Stream<Map.Entry<ResourceLocation, T>> allValues() {
            return this.valueProvider.stream();
        }
    }
}

