/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.ApiStatus;

public final class CommandOverrides {
    private static final String KEY_PLAYER_JOINED_WORLD = PuzzlesLibMod.id("joined_world").toString();
    private static final Map<CommandEnvironment, Collection<String>> COMMAND_OVERRIDES = Maps.newEnumMap(CommandEnvironment.class);

    private CommandOverrides() {
    }

    public static void registerServerCommand(String command, boolean onlyDedicated) {
        CommandEnvironment commandEnvironment = onlyDedicated ? CommandEnvironment.DEDICATED_SERVER : CommandEnvironment.SERVER;
        COMMAND_OVERRIDES.computeIfAbsent(commandEnvironment, $ -> new LinkedHashSet()).add(command);
    }

    public static void registerEffectCommand(Holder<MobEffect> holder) {
        CommandOverrides.registerPlayerCommand("effect give @s " + holder.getRegisteredName() + " infinite 127 true", false);
    }

    public static void registerPlayerCommand(String command, boolean onlyDedicated) {
        CommandEnvironment commandEnvironment = onlyDedicated ? CommandEnvironment.DEDICATED_PLAYER : CommandEnvironment.PLAYER;
        COMMAND_OVERRIDES.computeIfAbsent(commandEnvironment, $ -> new LinkedHashSet()).add(command);
    }

    @ApiStatus.Internal
    public static void registerEventHandlers() {
        ServerLifecycleEvents.STARTED.register(minecraftServer -> {
            if (minecraftServer.getWorldData().overworldData().getGameTime() == 0L && minecraftServer.getWorldData().isAllowCommands()) {
                CommandOverrides.executeCommandOverrides(minecraftServer, CommandEnvironment.SERVER, CommandEnvironment.DEDICATED_SERVER, UnaryOperator.identity());
            }
        });
        ServerEntityLevelEvents.LOAD.register((entity, serverLevel, isFreshEntity) -> {
            ServerPlayer serverPlayer;
            if (isFreshEntity && entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).getTags().contains(KEY_PLAYER_JOINED_WORLD)) {
                serverPlayer.addTag(KEY_PLAYER_JOINED_WORLD);
                if (serverLevel.getServer().isDedicatedServer() || serverLevel.getServer().getWorldData().isAllowCommands()) {
                    serverLevel.getServer().schedule((Runnable)new TickTask(serverLevel.getServer().getTickCount(), () -> {
                        String playerName = serverPlayer.getGameProfile().getName();
                        CommandOverrides.executeCommandOverrides(serverPlayer.getServer(), CommandEnvironment.PLAYER, CommandEnvironment.DEDICATED_PLAYER, s -> s.replaceAll("@[sp]", playerName));
                    }));
                }
            }
            return EventResult.PASS;
        });
        PlayerCopyEvents.COPY.register((originalServerPlayer, newServerPlayer, originalStillAlive) -> {
            if (!originalStillAlive) {
                originalServerPlayer.removeTag(KEY_PLAYER_JOINED_WORLD);
            }
        });
    }

    private static void executeCommandOverrides(MinecraftServer minecraftServer, CommandEnvironment commandEnvironment, CommandEnvironment dedicatedCommandEnvironment, UnaryOperator<String> formatter) {
        for (String command : (Collection)COMMAND_OVERRIDES.getOrDefault((Object)commandEnvironment, Collections.emptySet())) {
            minecraftServer.getCommands().performPrefixedCommand(minecraftServer.createCommandSourceStack(), (String)formatter.apply(command));
        }
        if (minecraftServer instanceof DedicatedServer) {
            for (String command : (Collection)COMMAND_OVERRIDES.getOrDefault((Object)dedicatedCommandEnvironment, Collections.emptySet())) {
                minecraftServer.getCommands().performPrefixedCommand(minecraftServer.createCommandSourceStack(), (String)formatter.apply(command));
            }
        }
    }

    private static enum CommandEnvironment {
        DEDICATED_SERVER,
        SERVER,
        DEDICATED_PLAYER,
        PLAYER;

    }
}

