/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.block.v1;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class BlockConversionHelper {
    private BlockConversionHelper() {
    }

    public static void setBlockItemBlock(BlockItem item, Block block) {
        BlockConversionHelper.setItemForBlock(block, (Item)item);
        BlockConversionHelper.setBlockForItem(item, block);
    }

    public static void setItemForBlock(Block block, Item item) {
        Objects.requireNonNull(block, "block " + (String)(item != null ? "for item '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item)) + "' " : "") + "is null");
        Objects.requireNonNull(item, "item for block '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)) + "' is null");
        Item.BY_BLOCK.put(block, item);
        block.item = item;
    }

    public static void setBlockForItem(BlockItem item, Block block) {
        Objects.requireNonNull(item, "item " + (String)(block != null ? "for block '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)) + "' " : "") + "is null");
        Objects.requireNonNull(block, "block for item '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item)) + "' is null");
        Block oldBlock = item.getBlock();
        if (oldBlock != null) {
            oldBlock.item = item;
        }
        item.block = block;
    }

    public static void copyBoundTags(Block from, Block to) {
        Objects.requireNonNull(from, "source " + (String)(to != null ? "for target '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)to)) + "' " : "") + "is null");
        Objects.requireNonNull(to, "target for source '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)from)) + "' is null");
        if (to.builtInRegistryHolder().tags().findAny().isPresent()) {
            throw new IllegalStateException("target block tags not empty");
        }
        List tagKeys = from.builtInRegistryHolder().tags().toList();
        to.builtInRegistryHolder().bindTags(tagKeys);
    }
}

