/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public final class ScreenTooltipFactory {
    private ScreenTooltipFactory() {
    }

    public static Tooltip create(FormattedText ... components) {
        return ScreenTooltipFactory.create(Arrays.asList(components));
    }

    public static Tooltip create(List<? extends FormattedText> formattedTexts) {
        List<FormattedCharSequence> tooltipLines = formattedTexts.stream().flatMap(ScreenTooltipFactory::splitTooltipLines).toList();
        return ScreenTooltipFactory.create(tooltipLines, null);
    }

    public static Stream<FormattedCharSequence> splitTooltipLines(FormattedText formattedText) {
        List splitLines = Minecraft.getInstance().font.split(formattedText, 170);
        if (splitLines.isEmpty()) {
            return Stream.of(FormattedCharSequence.EMPTY);
        }
        return splitLines.stream();
    }

    public static Tooltip create(final List<FormattedCharSequence> tooltipLines, final @Nullable BiFunction<ScreenRectangle, Boolean, ClientTooltipPositioner> positionerFactory) {
        return new Tooltip(CommonComponents.EMPTY, null){

            public List<FormattedCharSequence> toCharSequence(Minecraft minecraft) {
                return tooltipLines;
            }

            protected ClientTooltipPositioner createTooltipPositioner(boolean hovering, boolean focused, ScreenRectangle screenRectangle) {
                if (positionerFactory != null) {
                    return (ClientTooltipPositioner)positionerFactory.apply(screenRectangle, !hovering && focused && Minecraft.getInstance().getLastInputType().isKeyboard());
                }
                return super.createTooltipPositioner(hovering, focused, screenRectangle);
            }
        };
    }
}

