/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeProvider
extends RecipeProvider {
    protected final String modId;

    public AbstractRecipeProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractRecipeProvider(String modId, PackOutput packOutput) {
        super(packOutput);
        this.modId = modId;
    }

    @Nullable
    private static <T> JsonElement searchAndReplaceValue(@Nullable JsonElement jsonElement, T searchFor, T replaceWith) {
        block10: {
            block11: {
                Objects.requireNonNull(searchFor, "search for is null");
                Objects.requireNonNull(replaceWith, "replace with is null");
                if (jsonElement == null || jsonElement.isJsonNull()) break block10;
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isNumber()) {
                        if (searchFor.equals(jsonPrimitive.getAsNumber())) {
                            return new JsonPrimitive((Number)replaceWith);
                        }
                    } else if (jsonPrimitive.isBoolean()) {
                        if (searchFor.equals(jsonPrimitive.getAsBoolean())) {
                            return new JsonPrimitive((Boolean)replaceWith);
                        }
                    } else if (jsonPrimitive.isString() && searchFor.toString().equals(jsonPrimitive.getAsString())) {
                        return new JsonPrimitive(replaceWith.toString());
                    }
                    return jsonElement;
                }
                if (!jsonElement.isJsonArray()) break block11;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.set(i, AbstractRecipeProvider.searchAndReplaceValue(jsonArray.get(i), searchFor, replaceWith));
                }
                break block10;
            }
            if (!jsonElement.isJsonObject()) break block10;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                entry.setValue(AbstractRecipeProvider.searchAndReplaceValue((JsonElement)entry.getValue(), searchFor, replaceWith));
            }
        }
        return jsonElement;
    }

    public static String getHasName(ItemLike item, ItemLike ... items) {
        return "has_" + Stream.concat(Stream.of(item), Stream.of(items)).map(RecipeProvider::getItemName).collect(Collectors.joining("_and_"));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item, ItemLike ... items) {
        return AbstractRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of((ItemLike[])Stream.concat(Stream.of(item), Stream.of(items)).toArray(ItemLike[]::new)).build()});
    }

    public CompletableFuture<?> run(CachedOutput output) {
        ArrayList futures = new ArrayList();
        this.buildRecipes(new IdentifiableRecipeOutput(output, futures));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public final void buildRecipes(RecipeOutput recipeOutput) {
        this.addRecipes(recipeOutput);
    }

    public abstract void addRecipes(RecipeOutput var1);

    public class IdentifiableRecipeOutput
    implements RecipeOutput {
        private final CachedOutput output;
        private final List<CompletableFuture<?>> list;
        private final Set<ResourceLocation> set = Sets.newHashSet();

        public IdentifiableRecipeOutput(CachedOutput output, List<CompletableFuture<?>> list) {
            this.output = output;
            this.list = list;
        }

        public String getModId() {
            return AbstractRecipeProvider.this.modId;
        }

        public void accept(ResourceLocation location, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
            ResourceLocation oldLocation = location;
            if (!this.set.add(location = new ResourceLocation(AbstractRecipeProvider.this.modId, location.getPath()))) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(location));
            }
            this.list.add(DataProvider.saveStable((CachedOutput)this.output, (Codec)Recipe.CODEC, recipe, (Path)AbstractRecipeProvider.this.recipePathProvider.json(location)));
            if (advancement != null) {
                JsonElement jsonElement = (JsonElement)Util.getOrThrow((DataResult)Advancement.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)advancement.value()), IllegalStateException::new);
                jsonElement = AbstractRecipeProvider.searchAndReplaceValue(jsonElement, oldLocation, location);
                ResourceLocation advancementLocation = new ResourceLocation(AbstractRecipeProvider.this.modId, advancement.id().getPath());
                this.list.add(DataProvider.saveStable((CachedOutput)this.output, (JsonElement)jsonElement, (Path)AbstractRecipeProvider.this.advancementPathProvider.json(advancementLocation)));
            }
        }

        public Advancement.Builder advancement() {
            return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
        }
    }
}

