/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.entity.v1;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class GenericExplosionHelper {
    private GenericExplosionHelper() {
    }

    public static <T extends Explosion> T explode(ExplosionFactory<T> factory, Level level, @Nullable Entity source, double x, double y, double z, float radius, Level.ExplosionInteraction explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, Explosion.getDefaultDamageSource((Level)level, (Entity)source), null, x, y, z, radius, false, explosionInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public static <T extends Explosion> T explode(ExplosionFactory<T> factory, Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, SoundEvent explosionSound) {
        T explosion = GenericExplosionHelper.explode(factory, level, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, level.isClientSide, smallExplosionParticles, largeExplosionParticles, explosionSound);
        if (!level.isClientSide) {
            if (!explosion.interactsWithBlocks()) {
                explosion.clearToBlow();
            }
            for (ServerPlayer serverplayer : ((ServerLevel)level).players()) {
                if (!(serverplayer.distanceToSqr(x, y, z) < 4096.0)) continue;
                serverplayer.connection.send((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(serverplayer), explosion.getBlockInteraction(), explosion.getSmallExplosionParticles(), explosion.getLargeExplosionParticles(), explosion.getExplosionSound()));
            }
        }
        return explosion;
    }

    private static <T extends Explosion> T explode(ExplosionFactory<T> factory, Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, boolean spawnParticles, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, SoundEvent explosionSound) {
        T explosion = factory.create(level, source, damageSource, damageCalculator, x, y, z, radius, fire, GenericExplosionHelper.getBlockInteraction(level, source, explosionInteraction), smallExplosionParticles, largeExplosionParticles, explosionSound);
        if (CommonAbstractions.INSTANCE.onExplosionStart(level, (Explosion)explosion)) {
            return explosion;
        }
        explosion.explode();
        explosion.finalizeExplosion(spawnParticles);
        return explosion;
    }

    private static Explosion.BlockInteraction getBlockInteraction(Level level, @Nullable Entity source, Level.ExplosionInteraction explosionInteraction) {
        return switch (explosionInteraction) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> GenericExplosionHelper.getDestroyType(level.getGameRules(), (GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.MOB -> {
                if (CommonAbstractions.INSTANCE.getMobGriefingRule(level, source)) {
                    yield GenericExplosionHelper.getDestroyType(level.getGameRules(), (GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> GenericExplosionHelper.getDestroyType(level.getGameRules(), (GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.BLOW -> Explosion.BlockInteraction.TRIGGER_BLOCK;
        };
    }

    private static Explosion.BlockInteraction getDestroyType(GameRules gameRules, GameRules.Key<GameRules.BooleanValue> gameRule) {
        return gameRules.getBoolean(gameRule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    public static <T extends Explosion> T explode(ExplosionFactory<T> factory, Level level, @Nullable Entity source, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, Explosion.getDefaultDamageSource((Level)level, (Entity)source), null, x, y, z, radius, fire, explosionInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public static <T extends Explosion> T explode(ExplosionFactory<T> factory, Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, Vec3 pos, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, damageSource, damageCalculator, pos.x(), pos.y(), pos.z(), radius, fire, explosionInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public static <T extends Explosion> T explode(ExplosionFactory<T> factory, Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    @FunctionalInterface
    public static interface ExplosionFactory<T extends Explosion> {
        public T create(Level var1, @Nullable Entity var2, @Nullable DamageSource var3, @Nullable ExplosionDamageCalculator var4, double var5, double var7, double var9, float var11, boolean var12, Explosion.BlockInteraction var13, ParticleOptions var14, ParticleOptions var15, SoundEvent var16);
    }
}

