/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV3 {
    public static Builder builder(String modId) {
        return NetworkHandlerV3.builder(new ResourceLocation(modId, "main"));
    }

    public static Builder builder(ResourceLocation channelName) {
        return ModContext.get(channelName.getNamespace()).getNetworkHandlerV3(channelName);
    }

    public <T extends Record> Packet<ClientCommonPacketListener> toClientboundPacket(T var1);

    public <T extends Record> Packet<ServerCommonPacketListener> toServerboundPacket(T var1);

    default public <T extends Record> void sendMessage(PlayerSet playerSet, T message) {
        playerSet.notify(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendMessage(T message) {
        ClientPacketListener clientPacketListener = Proxy.INSTANCE.getClientPacketListener();
        Objects.requireNonNull(clientPacketListener, "client packet listener is null");
        clientPacketListener.send(this.toServerboundPacket(message));
    }

    default public <T extends Record> void sendToServer(T message) {
        this.sendMessage(message);
    }

    default public <T extends Record> void sendTo(ServerPlayer player, T message) {
        Objects.requireNonNull(player, "player is null");
        player.connection.send(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAll(MinecraftServer server, T message) {
        this.sendToAll(server, null, message);
    }

    default public <T extends Record> void sendToAll(MinecraftServer server, @Nullable ServerPlayer exclude, T message) {
        Objects.requireNonNull(server, "server is null");
        this.sendToAll(server.getPlayerList().getPlayers(), exclude, message);
    }

    default public <T extends Record> void sendToAll(Collection<ServerPlayer> playerList, @Nullable ServerPlayer exclude, T message) {
        Objects.requireNonNull(playerList, "player list is null");
        for (ServerPlayer player : playerList) {
            if (player == exclude) continue;
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAll(ServerLevel level, T message) {
        Objects.requireNonNull(level, "level is null");
        for (ServerPlayer player : level.players()) {
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAllNear(Vec3i pos, ServerLevel level, T message) {
        Objects.requireNonNull(pos, "pos is null");
        this.sendToAllNear(pos.getX(), pos.getY(), pos.getZ(), level, message);
    }

    default public <T extends Record> void sendToAllNear(double posX, double posY, double posZ, ServerLevel level, T message) {
        this.sendToAllNear(null, posX, posY, posZ, 64.0, level, message);
    }

    default public <T extends Record> void sendToAllNear(@Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, ServerLevel level, T message) {
        Objects.requireNonNull(level, "level is null");
        level.getServer().getPlayerList().broadcast((Player)exclude, posX, posY, posZ, distance, level.dimension(), this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTracking(BlockEntity blockEntity, T message) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        Level level = blockEntity.getLevel();
        Objects.requireNonNull(level, "block entity level is null");
        Preconditions.checkState((!level.isClientSide ? 1 : 0) != 0, (Object)"block entity level is client level");
        this.sendToAllNear((Vec3i)blockEntity.getBlockPos(), (ServerLevel)level, message);
    }

    default public <T extends Record> void sendToAllTracking(LevelChunk chunk, T message) {
        Objects.requireNonNull(chunk, "chunk is null");
        Preconditions.checkState((!chunk.getLevel().isClientSide ? 1 : 0) != 0, (Object)"chunk level is client level");
        this.sendToAllTracking((ServerLevel)chunk.getLevel(), chunk.getPos(), message);
    }

    default public <T extends Record> void sendToAllTracking(ServerLevel level, ChunkPos chunkPos, T message) {
        Objects.requireNonNull(level, "level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        List players = level.getChunkSource().chunkMap.getPlayers(chunkPos, false);
        this.sendToAll(players, null, message);
    }

    default public <T extends Record> void sendToAllTracking(Entity entity, T message, boolean includeSelf) {
        Objects.requireNonNull(entity, "entity is null");
        Preconditions.checkState((!entity.getCommandSenderWorld().isClientSide ? 1 : 0) != 0, (Object)"entity level is client level");
        ServerChunkCache chunkSource = ((ServerLevel)entity.getCommandSenderWorld()).getChunkSource();
        if (includeSelf) {
            chunkSource.broadcastAndSend(entity, this.toClientboundPacket(message));
        } else {
            chunkSource.broadcast(entity, this.toClientboundPacket(message));
        }
    }

    public static interface Builder
    extends NetworkHandlerRegistry,
    Buildable {
        default public <T> Builder registerSerializer(Class<T> type, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) {
            MessageSerializers.registerSerializer(type, writer, reader);
            return this;
        }

        default public <T> Builder registerSerializer(Class<? super T> type, ResourceKey<Registry<T>> resourceKey) {
            MessageSerializers.registerSerializer(type, resourceKey);
            return this;
        }

        default public <T> Builder registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
            MessageSerializers.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        public Builder optional();
    }
}

