/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public class PuzzlesLibClient
implements ClientModConstructor {
    @Override
    public void onConstructMod() {
        PuzzlesLibClient.setupDevelopmentEnvironment();
    }

    private static void setupDevelopmentEnvironment() {
        if (!ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironment() || ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            PuzzlesLibClient.setupGameOptions();
        }
        PuzzlesLibClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ScreenOpeningCallback.EVENT.register((oldScreen, newScreen) -> {
            Object patt1831$temp = newScreen.get();
            if (patt1831$temp instanceof CreateWorldScreen) {
                CreateWorldScreen screen = (CreateWorldScreen)patt1831$temp;
                screen.getUiState().setGameMode(WorldCreationUiState.SelectedGameMode.CREATIVE);
                screen.getUiState().setAllowCheats(true);
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseClick(Screen.class).register((screen, mouseX, mouseY, button) -> {
            for (GuiEventListener guiEventListener : screen.children()) {
                if (!(guiEventListener instanceof EditBox) || !guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
                screen.setFocused(guiEventListener);
                if (button == 0) {
                    screen.setDragging(true);
                }
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseRelease(Screen.class).register((screen, mouseX, mouseY, button) -> {
            screen.setDragging(false);
            return screen.getChildAt(mouseX, mouseY).filter(EditBox.class::isInstance).filter(guiEventListener -> guiEventListener.mouseReleased(mouseX, mouseY, button)).isPresent() ? EventResult.INTERRUPT : EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseDrag(Screen.class).register((screen, mouseX, mouseY, button, dragX, dragY) -> screen.getFocused() instanceof EditBox && screen.isDragging() && button == 0 && screen.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY) ? EventResult.INTERRUPT : EventResult.PASS);
    }

    private static void setupGameOptions() {
        Minecraft minecraft = Minecraft.getInstance();
        boolean running = minecraft.running;
        minecraft.running = false;
        PuzzlesLibClient.initializeGameOptions(minecraft.options);
        minecraft.running = running;
    }

    public static void initializeGameOptions(Options options) {
        if (options.getFile().exists()) {
            return;
        }
        options.renderDistance().set((Object)16);
        options.framerateLimit().set((Object)60);
        options.narratorHotkey().set((Object)false);
        options.advancedItemTooltips = true;
        options.tutorialStep = TutorialSteps.NONE;
        options.joinedFirstServer = true;
        options.hideBundleTutorial = true;
        options.operatorItemsTab().set((Object)true);
        options.entityShadows().set((Object)false);
        options.realmsNotifications().set((Object)false);
        options.showSubtitles().set((Object)true);
        options.guiScale().set((Object)5);
        options.onboardAccessibility = false;
        options.skipMultiplayerWarning = true;
    }

    @Override
    public void onClientSetup() {
        if (!ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironment() || ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        CreativeModeInventoryScreen.selectedTab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.getOrThrow(CreativeModeTabs.SEARCH);
    }
}

