/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import fuzs.puzzleslib.api.chat.v1.ComponentHelper;
import fuzs.puzzleslib.api.client.gui.v2.components.ScreenTooltipFactory;
import fuzs.puzzleslib.impl.core.ProxyImpl;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface ClientProxyImpl
extends ProxyImpl {
    @Override
    default public Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    default public Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    @Override
    default public ClientPacketListener getClientPacketListener() {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        Objects.requireNonNull(connection, "client packet listener is null");
        return connection;
    }

    @Override
    default public boolean hasControlDown() {
        return Screen.hasControlDown();
    }

    @Override
    default public boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    @Override
    default public boolean hasAltDown() {
        return Screen.hasAltDown();
    }

    @Override
    default public List<Component> splitTooltipLines(Component component) {
        return ScreenTooltipFactory.splitTooltipLines((FormattedText)component).map(ComponentHelper::toComponent).toList();
    }
}

