/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class CreativeModeTabConfiguratorImpl
implements CreativeModeTabConfigurator {
    private static final Item[] POTION_ITEMS = new Item[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION, Items.TIPPED_ARROW};
    private final ResourceLocation identifier;
    @Nullable
    private Supplier<ItemStack> icon;
    @Nullable
    private Supplier<ItemStack[]> icons;
    private CreativeModeTab.DisplayItemsGenerator displayItemsGenerator = (itemDisplayParameters, output) -> {};
    private boolean hasSearchBar;
    private boolean appendEnchantmentsAndPotions;

    public CreativeModeTabConfiguratorImpl(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public Supplier<ItemStack[]> getIcons() {
        return this.icons;
    }

    public boolean isHasSearchBar() {
        return this.hasSearchBar;
    }

    @Override
    public CreativeModeTabConfigurator icon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator icons(Supplier<ItemStack[]> icons) {
        this.icons = icons;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator displayItems(CreativeModeTab.DisplayItemsGenerator displayItemsGenerator) {
        this.displayItemsGenerator = displayItemsGenerator;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator withSearchBar() {
        this.hasSearchBar = true;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator appendEnchantmentsAndPotions() {
        this.appendEnchantmentsAndPotions = true;
        return this;
    }

    public void configure(CreativeModeTab.Builder builder) {
        String translationKey = "itemGroup.%s.%s".formatted(this.identifier.getNamespace(), this.identifier.getPath());
        builder.title((Component)Component.translatable((String)translationKey));
        if (this.icon != null) {
            builder.icon(this.icon);
        } else {
            Objects.requireNonNull(this.icons, "both icon suppliers are null");
            if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
                builder.icon(() -> {
                    ItemStack[] icons = this.icons.get();
                    Preconditions.checkState((icons.length > 0 ? 1 : 0) != 0, (Object)"icons is empty");
                    return icons[0];
                });
            }
        }
        if (this.appendEnchantmentsAndPotions) {
            builder.displayItems((itemDisplayParameters, output) -> {
                this.displayItemsGenerator.accept(itemDisplayParameters, output);
                CreativeModeTabConfiguratorImpl.appendAllEnchantments(this.identifier.getNamespace(), itemDisplayParameters.holders(), arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
                CreativeModeTabConfiguratorImpl.appendAllPotions(this.identifier.getNamespace(), itemDisplayParameters.holders(), arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
            });
        } else {
            builder.displayItems(this.displayItemsGenerator);
        }
    }

    private static void appendAllEnchantments(String namespace, HolderLookup.Provider holders, Consumer<ItemStack> itemStacks) {
        Comparator<Holder.Reference> comparator = Comparator.comparing(entry -> entry.key().location().getPath());
        holders.lookup(Registries.ENCHANTMENT).stream().flatMap(HolderLookup::listElements).filter(entry -> entry.key().location().getNamespace().equals(namespace)).sorted(comparator).map(Holder.Reference::value).forEach(enchantment -> itemStacks.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.getMaxLevel()))));
    }

    private static void appendAllPotions(String namespace, HolderLookup.Provider holders, Consumer<ItemStack> itemStacks) {
        Potion[] potions = (Potion[])holders.lookup(Registries.POTION).stream().flatMap(HolderLookup::listElements).filter(entry -> entry.key().location().getNamespace().equals(namespace)).map(Holder.Reference::value).filter(potion -> !potion.getEffects().isEmpty()).sorted(Comparator.comparing(potion -> (MobEffectInstance)potion.getEffects().get(0))).toArray(Potion[]::new);
        for (Item item : POTION_ITEMS) {
            for (Potion potion2 : potions) {
                itemStacks.accept(PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)item), (Potion)potion2));
            }
        }
    }
}

